/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterator.GraphIterator;
import org.eclipse.persistence.tools.utility.iterator.IteratorTools;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class GraphIteratorTests
extends TestCase {
    Collection<GraphNode> nodes = new ArrayList<GraphNode>();

    public GraphIteratorTests(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testHasNext1() {
        this.verifyHasNext(this.buildGraphIterator1());
    }

    public void testHasNext2() {
        this.verifyHasNext(this.buildGraphIterator2());
    }

    private void verifyHasNext(Iterator<GraphNode> iterator) {
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        GraphIteratorTests.assertEquals((int)this.nodes.size(), (int)i);
    }

    public void testNext1() {
        this.verifyNext(this.buildGraphIterator1());
    }

    public void testNext2() {
        this.verifyNext(this.buildGraphIterator2());
    }

    private void verifyNext(Iterator<GraphNode> iterator) {
        while (iterator.hasNext()) {
            GraphIteratorTests.assertTrue((String)"bogus element", (boolean)this.nodes.contains(iterator.next()));
        }
    }

    public void testNoSuchElementException1() {
        this.verifyNoSuchElementException(this.buildGraphIterator1());
    }

    public void testNoSuchElementException2() {
        this.verifyNoSuchElementException(this.buildGraphIterator2());
    }

    private void verifyNoSuchElementException(Iterator<GraphNode> iterator) {
        boolean exCaught = false;
        while (iterator.hasNext()) {
            iterator.next();
        }
        try {
            iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        GraphIteratorTests.assertTrue((String)"NoSuchElementException not thrown", (boolean)exCaught);
    }

    public void testSize1() {
        this.verifySize(this.buildGraphIterator1());
    }

    public void testSize2() {
        this.verifySize(this.buildGraphIterator2());
    }

    private void verifySize(Iterator<GraphNode> iterator) {
        int actualSize;
        int iteratorSize = IteratorTools.size(iterator);
        GraphIteratorTests.assertTrue((String)"Too few items in iterator.", (iteratorSize >= (actualSize = this.nodes.size()) ? 1 : 0) != 0);
        GraphIteratorTests.assertTrue((String)"Too many items in iterator.", (iteratorSize <= actualSize ? 1 : 0) != 0);
    }

    public void testInvalidGraphIterator() {
        boolean exCaught = false;
        try {
            GraphIterator iterator = new GraphIterator((Object)this.buildGraphRoot());
            GraphNode gn = (GraphNode)iterator.next();
            GraphIteratorTests.fail((String)("invalid graph node: " + gn));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        GraphIteratorTests.assertTrue((String)"NoSuchElementException not thrown", (boolean)exCaught);
    }

    private Iterator<GraphNode> buildGraphIterator1() {
        return new GraphIterator((Object)this.buildGraphRoot(), this.buildMisterRogers());
    }

    private GraphIterator.MisterRogers<GraphNode> buildMisterRogers() {
        return new GraphIterator.MisterRogers<GraphNode>(){

            public Iterator<GraphNode> neighbors(GraphNode next) {
                return next.neighbors();
            }
        };
    }

    private Iterator<GraphNode> buildGraphIterator2() {
        return new GraphIterator<GraphNode>(this.buildGraphRoot()){

            public Iterator<GraphNode> neighbors(GraphNode next) {
                return next.neighbors();
            }
        };
    }

    private GraphNode buildGraphRoot() {
        GraphNode ncNode = new GraphNode("North Carolina");
        GraphNode vaNode = new GraphNode("Virginia");
        GraphNode scNode = new GraphNode("South Carolina");
        GraphNode gaNode = new GraphNode("Georgia");
        GraphNode flNode = new GraphNode("Florida");
        GraphNode alNode = new GraphNode("Alabama");
        GraphNode msNode = new GraphNode("Mississippi");
        GraphNode tnNode = new GraphNode("Tennessee");
        ncNode.setNeighbors(new GraphNode[]{vaNode, scNode, gaNode, tnNode});
        vaNode.setNeighbors(new GraphNode[]{ncNode, tnNode});
        scNode.setNeighbors(new GraphNode[]{ncNode, gaNode});
        gaNode.setNeighbors(new GraphNode[]{ncNode, scNode, flNode, alNode, tnNode});
        flNode.setNeighbors(new GraphNode[]{gaNode});
        alNode.setNeighbors(new GraphNode[]{gaNode, msNode, tnNode});
        msNode.setNeighbors(new GraphNode[]{alNode, tnNode});
        tnNode.setNeighbors(new GraphNode[]{vaNode, ncNode, gaNode, alNode, msNode});
        return ncNode;
    }

    public class GraphNode {
        private String name;
        private Collection<GraphNode> neighbors = new ArrayList<GraphNode>();

        public GraphNode(String name) {
            GraphIteratorTests.this.nodes.add(this);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        void setNeighbors(GraphNode[] neighbors) {
            this.neighbors = ListTools.list((Object[])neighbors);
        }

        public Iterator<GraphNode> neighbors() {
            return this.neighbors.iterator();
        }

        public int neighborsSize() {
            return this.neighbors.size();
        }

        public String toString() {
            return "GraphNode(" + this.name + ")";
        }
    }
}

