/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.value;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.model.AbstractModel;
import org.eclipse.persistence.tools.utility.model.event.PropertyChangeEvent;
import org.eclipse.persistence.tools.utility.model.event.StateChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.ChangeAdapter;
import org.eclipse.persistence.tools.utility.model.listener.ChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.StateChangeListener;
import org.eclipse.persistence.tools.utility.model.value.SimplePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.ValueStateAdapter;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class ValueStateAdapterTests
extends TestCase {
    private Junk junk;
    private SimplePropertyValueModel<Junk> junkHolder;
    private ValueStateAdapter<Junk> junkHolder2;

    public ValueStateAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.junk = new Junk("foo");
        this.junkHolder = new SimplePropertyValueModel((Object)this.junk);
        this.junkHolder2 = new ValueStateAdapter(this.junkHolder);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testWrappedPVM() {
        Junk junk2 = new Junk("bar");
        LocalListener l = new LocalListener(this.junkHolder2, (Object)this.junk, (Object)junk2);
        this.junkHolder2.addChangeListener((ChangeListener)l);
        this.junkHolder.setValue((Object)junk2);
        ValueStateAdapterTests.assertTrue((boolean)l.eventReceived());
    }

    public void testHasPropertyChangeListeners() throws Exception {
        ValueStateAdapterTests.assertFalse((boolean)this.junkHolder.hasAnyPropertyChangeListeners("value"));
        ValueStateAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyPropertyChangeListeners("value"));
        LocalListener l = new LocalListener(this.junkHolder2, null, (Object)this.junk);
        this.junkHolder2.addChangeListener((ChangeListener)l);
        ValueStateAdapterTests.assertTrue((boolean)this.junkHolder.hasAnyPropertyChangeListeners("value"));
        ValueStateAdapterTests.assertTrue((boolean)this.junkHolder2.hasAnyPropertyChangeListeners("value"));
        this.junkHolder2.removeChangeListener((ChangeListener)l);
        ValueStateAdapterTests.assertFalse((boolean)this.junkHolder.hasAnyPropertyChangeListeners("value"));
        ValueStateAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyPropertyChangeListeners("value"));
    }

    public void testHasStateChangeListeners() throws Exception {
        ValueStateAdapterTests.assertFalse((boolean)this.junk.hasAnyStateChangeListeners());
        ValueStateAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyStateChangeListeners());
        LocalListener l = new LocalListener(this.junkHolder2, null, (Object)this.junk);
        this.junkHolder2.addStateChangeListener((StateChangeListener)l);
        ValueStateAdapterTests.assertTrue((boolean)this.junk.hasAnyStateChangeListeners());
        ValueStateAdapterTests.assertTrue((boolean)this.junkHolder2.hasAnyStateChangeListeners());
        this.junkHolder2.removeStateChangeListener((StateChangeListener)l);
        ValueStateAdapterTests.assertFalse((boolean)this.junk.hasAnyStateChangeListeners());
        ValueStateAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyStateChangeListeners());
    }

    public void testChangeState() {
        LocalListener l = new LocalListener(this.junkHolder2, null, (Object)this.junk);
        this.junkHolder2.addChangeListener((ChangeListener)l);
        this.junkHolder2.addStateChangeListener((StateChangeListener)l);
        this.junk.setName("bar");
        ValueStateAdapterTests.assertTrue((boolean)l.eventReceived());
    }

    class Junk
    extends AbstractModel {
        private String name;
        public static final String NAME_PROPERTY = "name";

        public Junk(String name) {
            this.name = name;
        }

        public void setName(String name) {
            this.name = name;
            this.fireStateChanged();
        }

        public String toString() {
            return "Junk(" + this.name + ")";
        }
    }

    class LocalListener
    extends ChangeAdapter {
        private boolean eventReceived = false;
        private final Object source;
        private final Object oldValue;
        private final Object newValue;

        LocalListener(Object source) {
            this(source, null, null);
        }

        LocalListener(Object source, Object oldValue, Object newValue) {
            this.source = source;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public void propertyChanged(PropertyChangeEvent e) {
            this.eventReceived = true;
            ValueStateAdapterTests.assertEquals((Object)this.source, (Object)e.getSource());
            ValueStateAdapterTests.assertEquals((Object)this.oldValue, (Object)e.getOldValue());
            ValueStateAdapterTests.assertEquals((Object)this.newValue, (Object)e.getNewValue());
            ValueStateAdapterTests.assertEquals((String)"value", (String)e.getPropertyName());
        }

        public void stateChanged(StateChangeEvent e) {
            this.eventReceived = true;
            ValueStateAdapterTests.assertEquals((Object)this.source, (Object)e.getSource());
        }

        boolean eventReceived() {
            return this.eventReceived;
        }
    }
}

