/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.db.EclipseLinkConnectionProfile;
import org.eclipse.persistence.tools.db.EclipseLinkSchema;
import org.eclipse.persistence.tools.db.driver.WorkbenchDriverAdapter;
import org.eclipse.persistence.tools.db.driver.WorkbenchDriverAdapterManager;
import org.eclipse.persistence.tools.db.model.ELDatabase;
import org.eclipse.persistence.tools.db.model.ELLoginSpec;
import org.eclipse.persistence.tools.db.model.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.db.model.spi.ExternalTableDescription;
import org.eclipse.persistence.tools.gen.db.Catalog;
import org.eclipse.persistence.tools.gen.db.ConnectionProfile;
import org.eclipse.persistence.tools.gen.db.Database;
import org.eclipse.persistence.tools.gen.db.Schema;
import org.eclipse.persistence.tools.gen.db.Table;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.iterable.ArrayIterable;
import org.eclipse.persistence.tools.utility.iterable.TransformationIterable;

public class EclipseLinkDatabase
implements Database {
    private ELDatabase mwDatabase;
    private WorkbenchDriverAdapter workbenchDriverAdapter;

    public EclipseLinkDatabase(String dbPlatformName, String driverClassName, String connectionURL, String userName, String password) {
        this.initialize(dbPlatformName, driverClassName, connectionURL, userName, password);
    }

    public String convertNameToIdentifier(String name) {
        return this.workbenchDriverAdapter.convertNameToIdentifier(name);
    }

    public Catalog getCatalogForIdentifier(String identifier) {
        throw new UnsupportedOperationException("Not supported!");
    }

    public Catalog getCatalogNamed(String name) {
        throw new UnsupportedOperationException("Not supported!");
    }

    public Iterable<Catalog> getCatalogs() {
        return new ArrayList<Catalog>();
    }

    public int getCatalogsSize() {
        return 0;
    }

    public ConnectionProfile getConnectionProfile() {
        return new EclipseLinkConnectionProfile(this, this.getMWDatabase());
    }

    public Database getDatabase() {
        return this;
    }

    public Catalog getDefaultCatalog() {
        throw new UnsupportedOperationException("Not supported!");
    }

    public String getDefaultCatalogIdentifier() {
        throw new UnsupportedOperationException("Not supported!");
    }

    public Schema getDefaultSchema() {
        return null;
    }

    public String getDefaultSchemaIdentifier() {
        return null;
    }

    public String getIdentifier() {
        return this.convertNameToIdentifier(this.getName());
    }

    public String getIdentifier(String defaultName) {
        return null;
    }

    public String getIdentifier(String name, String defaultName) {
        return this.workbenchDriverAdapter.convertNameToIdentifier(name, defaultName);
    }

    private ELDatabase getMWDatabase() {
        return this.mwDatabase;
    }

    public String getName() {
        return null;
    }

    public Schema getSchemaForIdentifier(String identifier) {
        return this.getSchemaNamed(identifier);
    }

    public Schema getSchemaNamed(String name) {
        return new EclipseLinkSchema(this, this.getMWDatabase(), name);
    }

    public Iterable<Schema> getSchemata() {
        return new TransformationIterable<String, Schema>((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return EclipseLinkDatabase.this.getMWDatabase().schemaNames();
            }
        }){

            protected Schema transform(String schemaName) {
                return new EclipseLinkSchema(EclipseLinkDatabase.this, EclipseLinkDatabase.this.getMWDatabase(), schemaName);
            }
        };
    }

    public int getSchemataSize() {
        return this.mwDatabase.getExternalDatabase().getSchemaNames().length;
    }

    public Iterable<String> getSortedCatalogIdentifiers() {
        throw new UnsupportedOperationException("Not supported!");
    }

    public Iterable<String> getSortedCatalogNames() {
        throw new UnsupportedOperationException("Not supported!");
    }

    public Iterable<String> getSortedSchemaIdentifiers() {
        return this.getSortedSchemaNames();
    }

    public Iterable<String> getSortedSchemaNames() {
        return new ArrayIterable((Object[])this.mwDatabase.getExternalDatabase().getSchemaNames());
    }

    public String getVendorName() {
        return this.getMWDatabase().getDatabasePlatform().getName();
    }

    public String getVersion() {
        return this.getMWDatabase().getDatabasePlatform().getName();
    }

    private void initialize(String dbPlatformName, String driverClassName, String connectionURL, String userName, String password) {
        this.mwDatabase = new ELDatabase(DatabasePlatformRepository.getDefault().platformNamed(dbPlatformName));
        ELLoginSpec loginSpec = this.getMWDatabase().addLoginSpec("dbProject_spec");
        loginSpec.setURL(connectionURL);
        loginSpec.setUserName(userName);
        loginSpec.setPassword(password);
        loginSpec.setDriverClassName(driverClassName);
        try {
            this.mwDatabase.login();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.mwDatabase.importQualifiedTablesFor((Collection<ExternalTableDescription>)CollectionTools.collection(this.mwDatabase.externalTableDescriptions()));
        this.workbenchDriverAdapter = WorkbenchDriverAdapterManager.instance().buildAdapter(this.getVendorName(), this);
    }

    public Table selectTableForIdentifier(Iterable<Table> tables, String identifier) {
        throw new UnsupportedOperationException("Not supported!");
    }

    public boolean supportsCatalogs() {
        return false;
    }
}

