/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.relational.platformsmodel;

import org.eclipse.persistence.tools.db.relational.platformsmodel.AbstractJDBCTypeToJavaTypeDeclarationMapping;
import org.eclipse.persistence.tools.db.relational.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.db.relational.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.db.relational.platformsmodel.JDBCTypeRepository;
import org.w3c.dom.Node;

public final class JavaTypeDeclarationToJDBCTypeMapping
extends AbstractJDBCTypeToJavaTypeDeclarationMapping {
    public static final String JDBC_TYPE_PROPERTY = "jdbcType";

    JavaTypeDeclarationToJDBCTypeMapping(JDBCTypeRepository repository, Node node) throws CorruptXMLException {
        super(repository, node);
    }

    JavaTypeDeclarationToJDBCTypeMapping(JDBCTypeRepository repository, String javaClassName, int arrayDepth, JDBCType jdbcType) {
        super(repository, jdbcType, javaClassName, arrayDepth);
    }

    public void setJDBCType(JDBCType jdbcType) {
        if (jdbcType == null) {
            throw new NullPointerException();
        }
        JDBCType old = this.jdbcType;
        this.jdbcType = jdbcType;
        this.firePropertyChanged(JDBC_TYPE_PROPERTY, (Object)old, (Object)jdbcType);
    }

    boolean maps(String javaClassName, int arrayDepth) {
        return this.javaTypeDeclaration.equals(javaClassName, arrayDepth);
    }

    @Override
    void write(Node node) {
        this.writeJavaTypeDeclaration(node);
        this.writeJDBCType(node);
    }

    @Override
    public void displayStringOn(StringBuffer sb) {
        this.javaTypeDeclaration.displayStringOn(sb);
        sb.append(" => ");
        sb.append(this.jdbcType.getName());
    }
}

