/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility;

import java.io.Serializable;
import org.eclipse.persistence.tools.utility.ExceptionHandler;
import org.eclipse.persistence.tools.utility.ObjectTools;

public interface MultiThreadedExceptionHandler
extends ExceptionHandler {
    public void handleException(Thread var1, Throwable var2);

    public static final class Default
    implements MultiThreadedExceptionHandler,
    Serializable {
        public static final ExceptionHandler INSTANCE = new Default();
        private static final long serialVersionUID = 1L;

        public static ExceptionHandler instance() {
            return INSTANCE;
        }

        private Default() {
        }

        @Override
        public void handleException(Thread thread, Throwable t) {
            this.handleException(t);
        }

        @Override
        public void handleException(Throwable t) {
            t.printStackTrace();
        }

        public String toString() {
            return ObjectTools.singletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static final class Null
    implements MultiThreadedExceptionHandler,
    Serializable {
        public static final ExceptionHandler INSTANCE = new Null();
        private static final long serialVersionUID = 1L;

        public static ExceptionHandler instance() {
            return INSTANCE;
        }

        private Null() {
        }

        @Override
        public void handleException(Thread thread, Throwable t) {
        }

        @Override
        public void handleException(Throwable t) {
        }

        public String toString() {
            return ObjectTools.singletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static final class Runtime
    implements MultiThreadedExceptionHandler,
    Serializable {
        public static final ExceptionHandler INSTANCE = new Runtime();
        private static final long serialVersionUID = 1L;

        public static ExceptionHandler instance() {
            return INSTANCE;
        }

        private Runtime() {
        }

        @Override
        public void handleException(Thread thread, Throwable t) {
            this.handleException(t);
        }

        @Override
        public void handleException(Throwable t) {
            t.printStackTrace();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }

        public String toString() {
            return ObjectTools.singletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

