/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.utility.collection.Bag;
import org.eclipse.persistence.tools.utility.collection.HashBag;

public class IdentityHashBag<E>
extends AbstractCollection<E>
implements Bag<E>,
Cloneable,
Serializable {
    transient Entry<E>[] table;
    transient int size = 0;
    transient int uniqueCount = 0;
    private int threshold;
    private final float loadFactor;
    transient int modCount = 0;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final Iterator EMPTY_ITERATOR = new EmptyIterator();
    private static final long serialVersionUID = 1L;

    public IdentityHashBag() {
        this(16);
    }

    public IdentityHashBag(int initialCapacity) {
        this(initialCapacity, 0.75f, false);
    }

    public IdentityHashBag(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, true);
    }

    private IdentityHashBag(int initialCapacity, float loadFactor, boolean validateParms) {
        int capacity = initialCapacity;
        if (validateParms) {
            if (capacity < 0) {
                throw new IllegalArgumentException("Illegal Initial Capacity: " + capacity);
            }
            if (capacity > 0x40000000) {
                capacity = 0x40000000;
            }
            if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
                throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
            }
            capacity = 1;
            while (capacity < initialCapacity) {
                capacity <<= 1;
            }
        }
        this.loadFactor = loadFactor;
        this.table = this.buildTable(capacity);
        this.threshold = (int)((float)capacity * loadFactor);
    }

    public IdentityHashBag(Collection<? extends E> c) {
        this(Math.max((int)((float)c.size() / 0.75f) + 1, 16), 0.75f);
        super.addAll_(c);
    }

    private int index(Object o) {
        return this.index(this.hash(o));
    }

    private int hash(Object o) {
        return o == null ? 0 : this.tweakHash(System.identityHashCode(o));
    }

    private int tweakHash(int h) {
        return h;
    }

    private int index(int hash) {
        return this.index(hash, this.table.length);
    }

    int index(int hash, int length) {
        return hash & length - 1;
    }

    private void addAll_(Iterable<? extends E> c) {
        for (E e : c) {
            this.add_(e);
        }
    }

    private void add_(E o) {
        this.add_(o, 1);
    }

    private void add_(E o, int cnt) {
        int hash = this.hash(o);
        int index = this.index(hash);
        Entry<E> e = this.table[index];
        while (e != null) {
            if (e.object == o) {
                e.count += cnt;
                this.size += cnt;
                return;
            }
            e = e.next;
        }
        this.table[index] = e = this.buildEntry(hash, o, cnt, this.table[index]);
        this.size += cnt;
        ++this.uniqueCount;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private Entry<E> getEntry(Object o) {
        Entry<E> e = this.table[this.index(o)];
        while (e != null) {
            if (e.object == o) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean contains(Object o) {
        return this.getEntry(o) != null;
    }

    @Override
    public int count(Object o) {
        Entry<E> e = this.getEntry(o);
        return e == null ? 0 : e.count;
    }

    private void rehash() {
        Entry<E>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int newCapacity = 2 * oldCapacity;
        Entry<E>[] newTable = this.buildTable(newCapacity);
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<E> old = oldTable[i];
            while (old != null) {
                Entry<E> e = old;
                old = old.next;
                int index = this.index(e.hash, newCapacity);
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    private Entry<E>[] buildTable(int capacity) {
        return new Entry[capacity];
    }

    @Override
    public boolean add(E o) {
        return this.add(o, 1);
    }

    @Override
    public boolean add(E o, int cnt) {
        if (cnt <= 0) {
            return false;
        }
        ++this.modCount;
        int hash = this.hash(o);
        int index = this.index(hash);
        Entry<E> e = this.table[index];
        while (e != null) {
            if (e.object == o) {
                e.count += cnt;
                this.size += cnt;
                return true;
            }
            e = e.next;
        }
        if (this.uniqueCount >= this.threshold) {
            this.rehash();
            index = this.index(hash);
        }
        this.table[index] = e = this.buildEntry(hash, o, cnt, this.table[index]);
        this.size += cnt;
        ++this.uniqueCount;
        return true;
    }

    private Entry<E> buildEntry(int hash, Object o, int cnt, Entry next) {
        return new Entry<Object>(hash, o, cnt, next);
    }

    @Override
    public boolean remove(Object o) {
        return this.remove(o, 1);
    }

    @Override
    public boolean remove(Object o, int cnt) {
        if (cnt <= 0) {
            return false;
        }
        int index = this.index(o);
        Entry<E> e = this.table[index];
        Entry<E> prev = null;
        while (e != null) {
            if (e.object == o) {
                ++this.modCount;
                cnt = cnt < e.count ? cnt : e.count;
                e.count -= cnt;
                if (e.count == 0) {
                    if (prev == null) {
                        this.table[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    --this.uniqueCount;
                }
                this.size -= cnt;
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return super.removeAll(new IdentityHashBag(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(new IdentityHashBag(c));
    }

    @Override
    public void clear() {
        Entry<E>[] tab = this.table;
        ++this.modCount;
        int i = tab.length;
        while (i-- > 0) {
            tab[i] = null;
        }
        this.size = 0;
        this.uniqueCount = 0;
    }

    public IdentityHashBag<E> clone() {
        try {
            IdentityHashBag clone = (IdentityHashBag)super.clone();
            clone.table = this.buildTable(this.table.length);
            clone.size = 0;
            clone.uniqueCount = 0;
            clone.modCount = 0;
            clone.addAll_(this);
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.size == 0 ? EMPTY_ITERATOR : new HashIterator();
    }

    @Override
    public Iterator<E> uniqueIterator() {
        return this.size == 0 ? EMPTY_ITERATOR : new UniqueIterator();
    }

    @Override
    public int uniqueCount() {
        return this.uniqueCount;
    }

    @Override
    public Iterator<Bag.Entry<E>> entries() {
        return this.size == 0 ? EMPTY_ITERATOR : new EntryIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IdentityHashBag) {
            IdentityHashBag b = (IdentityHashBag)o;
            if (b.size() != this.size()) {
                return false;
            }
            if (b.uniqueCount() != this.uniqueCount()) {
                return false;
            }
            Iterator<Bag.Entry<E>> stream = b.entries();
            while (stream.hasNext()) {
                Bag.Entry<E> entry = stream.next();
                if (entry.getCount() == this.count(entry.getElement())) continue;
                return false;
            }
            return true;
        }
        return this.equals_(o);
    }

    private boolean equals_(Object o) {
        return o instanceof Bag && new HashBag(this).equals(o);
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (E o : this) {
            h += System.identityHashCode(o);
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.uniqueCount);
        if (this.uniqueCount > 0) {
            Entry<E>[] entryArray = this.table;
            int n = this.table.length;
            int n2 = 0;
            while (n2 < n) {
                Entry<E> entry = entryArray[n2];
                while (entry != null) {
                    s.writeObject(entry.object);
                    s.writeInt(entry.count);
                    entry = entry.next;
                }
                ++n2;
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.table = this.buildTable(s.readInt());
        int unique = s.readInt();
        int i = 0;
        while (i < unique) {
            Object element = s.readObject();
            int elementCount = s.readInt();
            this.add_(element, elementCount);
            ++i;
        }
    }

    private static class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static class Entry<E>
    implements Bag.Entry<E> {
        final int hash;
        final E object;
        int count;
        Entry<E> next;

        Entry(int hash, E object, int count, Entry<E> next) {
            this.hash = hash;
            this.object = object;
            this.count = count;
            this.next = next;
        }

        @Override
        public E getElement() {
            return this.object;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int setCount(int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("count must be greater than zero: " + count);
            }
            int old = this.count;
            this.count = count;
            return old;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Bag.Entry)) {
                return false;
            }
            Bag.Entry e = (Bag.Entry)o;
            return this.object == e.getElement() && this.count == e.getCount();
        }

        @Override
        public int hashCode() {
            E o = this.object;
            return o == null ? 0 : this.count * o.hashCode();
        }

        public String toString() {
            return this.object + "=>" + this.count;
        }
    }

    private class EntryIterator
    implements Iterator<Entry<E>> {
        private int index;
        private Entry<E> nextEntry;
        private Entry<E> lastReturnedEntry;
        private int expectedModCount;

        EntryIterator() {
            this.index = IdentityHashBag.this.table.length;
            this.nextEntry = null;
            this.lastReturnedEntry = null;
            this.expectedModCount = IdentityHashBag.this.modCount;
        }

        @Override
        public boolean hasNext() {
            Entry e = this.nextEntry;
            int i = this.index;
            Entry<E>[] tab = IdentityHashBag.this.table;
            while (e == null && i > 0) {
                e = tab[--i];
            }
            this.nextEntry = e;
            this.index = i;
            return e != null;
        }

        @Override
        public Entry<E> next() {
            if (IdentityHashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry et = this.nextEntry;
            int i = this.index;
            Entry<E>[] tab = IdentityHashBag.this.table;
            while (et == null && i > 0) {
                et = tab[--i];
            }
            this.nextEntry = et;
            this.index = i;
            if (et == null) {
                throw new NoSuchElementException();
            }
            this.lastReturnedEntry = this.nextEntry;
            Entry e = this.lastReturnedEntry;
            this.nextEntry = e.next;
            return e;
        }

        @Override
        public void remove() {
            if (this.lastReturnedEntry == null) {
                throw new IllegalStateException();
            }
            if (IdentityHashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int slot = IdentityHashBag.this.index(this.lastReturnedEntry.hash, IdentityHashBag.this.table.length);
            Entry e = IdentityHashBag.this.table[slot];
            Entry prev = null;
            while (e != null) {
                if (e == this.lastReturnedEntry) {
                    ++IdentityHashBag.this.modCount;
                    ++this.expectedModCount;
                    if (prev == null) {
                        IdentityHashBag.this.table[slot] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    --IdentityHashBag.this.uniqueCount;
                    IdentityHashBag.this.size -= this.lastReturnedEntry.count;
                    this.lastReturnedEntry = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private class HashIterator
    implements Iterator<E> {
        private int index;
        private Entry<E> nextEntry;
        private int nextEntryCount;
        private Entry<E> lastReturnedEntry;
        private int expectedModCount;

        HashIterator() {
            this.index = IdentityHashBag.this.table.length;
            this.nextEntry = null;
            this.nextEntryCount = 0;
            this.lastReturnedEntry = null;
            this.expectedModCount = IdentityHashBag.this.modCount;
        }

        @Override
        public boolean hasNext() {
            Entry e = this.nextEntry;
            int i = this.index;
            Entry<E>[] tab = IdentityHashBag.this.table;
            while (e == null && i > 0) {
                e = tab[--i];
            }
            this.nextEntry = e;
            this.index = i;
            return e != null;
        }

        @Override
        public E next() {
            if (IdentityHashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry et = this.nextEntry;
            int i = this.index;
            Entry<E>[] tab = IdentityHashBag.this.table;
            while (et == null && i > 0) {
                et = tab[--i];
            }
            this.nextEntry = et;
            this.index = i;
            if (et == null) {
                throw new NoSuchElementException();
            }
            this.lastReturnedEntry = this.nextEntry;
            Entry e = this.lastReturnedEntry;
            ++this.nextEntryCount;
            if (this.nextEntryCount == e.count) {
                this.nextEntry = e.next;
                this.nextEntryCount = 0;
            }
            return e.object;
        }

        @Override
        public void remove() {
            if (this.lastReturnedEntry == null) {
                throw new IllegalStateException();
            }
            if (IdentityHashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int slot = IdentityHashBag.this.index(this.lastReturnedEntry.hash, IdentityHashBag.this.table.length);
            Entry e = IdentityHashBag.this.table[slot];
            Entry prev = null;
            while (e != null) {
                if (e == this.lastReturnedEntry) {
                    ++IdentityHashBag.this.modCount;
                    ++this.expectedModCount;
                    --e.count;
                    if (e.count == 0) {
                        if (prev == null) {
                            IdentityHashBag.this.table[slot] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                        --IdentityHashBag.this.uniqueCount;
                    } else {
                        --this.nextEntryCount;
                    }
                    --IdentityHashBag.this.size;
                    this.lastReturnedEntry = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private class UniqueIterator
    implements Iterator<E> {
        private EntryIterator entryIterator;

        UniqueIterator() {
            this.entryIterator = new EntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public E next() {
            return ((Entry)this.entryIterator.next()).object;
        }

        @Override
        public void remove() {
            this.entryIterator.remove();
        }
    }
}

