/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.command;

import org.eclipse.persistence.tools.utility.ExceptionHandler;
import org.eclipse.persistence.tools.utility.ListenerList;
import org.eclipse.persistence.tools.utility.command.Command;
import org.eclipse.persistence.tools.utility.command.CommandExecutor;
import org.eclipse.persistence.tools.utility.command.NotifyingRepeatingCommand;
import org.eclipse.persistence.tools.utility.command.RepeatingCommandWrapper;

public class NotifyingRepeatingCommandWrapper
extends RepeatingCommandWrapper
implements NotifyingRepeatingCommand {
    private final ListenerList<NotifyingRepeatingCommand.Listener> listenerList = new ListenerList<NotifyingRepeatingCommand.Listener>(NotifyingRepeatingCommand.Listener.class);

    public NotifyingRepeatingCommandWrapper(Command command, ExceptionHandler exceptionHandler) {
        super(command, exceptionHandler);
    }

    public NotifyingRepeatingCommandWrapper(Command command, CommandExecutor startCommandExecutor, ExceptionHandler exceptionHandler) {
        super(command, startCommandExecutor, exceptionHandler);
    }

    @Override
    public void addListener(NotifyingRepeatingCommand.Listener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeListener(NotifyingRepeatingCommand.Listener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    void executeCommand() {
        super.executeCommand();
        if (this.state.isQuiesced()) {
            this.executionQuiesced();
        }
    }

    private void executionQuiesced() {
        for (NotifyingRepeatingCommand.Listener listener : this.listenerList.getListeners()) {
            try {
                listener.executionQuiesced(this);
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleException(ex);
            }
        }
    }
}

