/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.persistence.tools.utility.StringTools;

public class IndentingPrintWriter
extends PrintWriter {
    private final String indent;
    private volatile int indentLevel;
    private final String lineSeparator;
    private volatile boolean needsIndent = true;
    public static String DEFAULT_INDENT = "\t";

    public IndentingPrintWriter(Writer out) {
        this(out, DEFAULT_INDENT, StringTools.CR);
    }

    public IndentingPrintWriter(Writer out, String indent) {
        this(out, indent, 0, StringTools.CR);
    }

    public IndentingPrintWriter(Writer out, String indent, String lineSeparator) {
        this(out, indent, 0, lineSeparator);
    }

    public IndentingPrintWriter(Writer out, String indent, int initialIndentLevel) {
        this(out, indent, initialIndentLevel, StringTools.CR);
    }

    public IndentingPrintWriter(Writer out, String indent, int initialIndentLevel, String lineSeparator) {
        super(out);
        if (indent == null || lineSeparator == null) {
            throw new NullPointerException();
        }
        this.indent = indent;
        this.indentLevel = initialIndentLevel;
        this.lineSeparator = lineSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.println_();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    private void println_() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
        this.out.write(this.lineSeparator);
        this.needsIndent = true;
    }

    private void printIndent() {
        if (this.needsIndent) {
            this.needsIndent = false;
            int i = this.indentLevel;
            while (i-- > 0) {
                this.print(this.indent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] buf, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            this.printIndent();
            super.write(buf, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) {
        Object object = this.lock;
        synchronized (object) {
            this.printIndent();
            super.write(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String s, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            this.printIndent();
            super.write(s, off, len);
        }
    }

    public void indent() {
        this.incrementIndentLevel();
    }

    public void undent() {
        this.decrementIndentLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementIndentLevel() {
        Object object = this.lock;
        synchronized (object) {
            ++this.indentLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementIndentLevel() {
        Object object = this.lock;
        synchronized (object) {
            --this.indentLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndentLevel() {
        Object object = this.lock;
        synchronized (object) {
            return this.indentLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setIndentLevel(int indentLevel) {
        Object object = this.lock;
        synchronized (object) {
            int old = this.indentLevel;
            this.indentLevel = indentLevel;
            return old;
        }
    }
}

