/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.persistence.tools.utility.StringBuilderTools;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.collection.HashBag;
import org.eclipse.persistence.tools.utility.iterator.ReadOnlyIterator;
import org.eclipse.persistence.tools.utility.model.event.CollectionAddEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionChangeEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionClearEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionRemoveEvent;
import org.eclipse.persistence.tools.utility.model.value.CollectionValueModel;
import org.eclipse.persistence.tools.utility.model.value.CollectionValueModelWrapper;
import org.eclipse.persistence.tools.utility.model.value.ListCollectionValueModelAdapter;
import org.eclipse.persistence.tools.utility.model.value.ListValueModel;

public class SetCollectionValueModel<E>
extends CollectionValueModelWrapper<E>
implements CollectionValueModel<E> {
    private final HashBag<E> bag = new HashBag();

    public SetCollectionValueModel(CollectionValueModel<? extends E> collectionHolder) {
        super(collectionHolder);
    }

    public SetCollectionValueModel(ListValueModel<E> listHolder) {
        this(new ListCollectionValueModelAdapter<E>(listHolder));
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyIterator<E>(this.bag.uniqueIterator());
    }

    @Override
    public int size() {
        return this.bag.uniqueCount();
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        CollectionTools.addAll(this.bag, this.collectionModel);
    }

    @Override
    protected void disengageModel() {
        super.disengageModel();
        this.bag.clear();
    }

    @Override
    protected void itemsAdded(CollectionAddEvent event) {
        ArrayList addedItems = new ArrayList(event.getItemsSize());
        int uniqueCount = this.bag.uniqueCount();
        for (Object item : this.getItems(event)) {
            this.bag.add(item);
            if (this.bag.uniqueCount() <= uniqueCount) continue;
            uniqueCount = this.bag.uniqueCount();
            addedItems.add(item);
        }
        this.fireItemsAdded("values", addedItems);
    }

    @Override
    protected void itemsRemoved(CollectionRemoveEvent event) {
        ArrayList removedItems = new ArrayList(event.getItemsSize());
        int uniqueCount = this.bag.uniqueCount();
        for (Object item : this.getItems(event)) {
            if (this.bag.remove(item)) {
                if (this.bag.uniqueCount() >= uniqueCount) continue;
                uniqueCount = this.bag.uniqueCount();
                removedItems.add(item);
                continue;
            }
            throw new IllegalStateException("missing item: " + item);
        }
        this.fireItemsRemoved("values", removedItems);
    }

    @Override
    protected void collectionCleared(CollectionClearEvent event) {
        this.clearCollection(this.bag, "values");
    }

    @Override
    protected void collectionChanged(CollectionChangeEvent event) {
        this.bag.clear();
        CollectionTools.addAll(this.bag, this.collectionModel);
        this.fireCollectionChanged("values", new HashSet<E>(this.bag));
    }

    @Override
    public void toString(StringBuilder sb) {
        StringBuilderTools.append(sb, this);
    }
}

