/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.tests.dom.orm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.annotations.ChangeTrackingType;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.mapping.ExternalProperty;
import org.eclipse.persistence.tools.mapping.orm.AccessType;
import org.eclipse.persistence.tools.mapping.orm.ExternalAccessMethods;
import org.eclipse.persistence.tools.mapping.orm.ExternalAssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalAttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalClassConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalCloneCopyPolicy;
import org.eclipse.persistence.tools.mapping.orm.ExternalCopyPolicy;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddable;
import org.eclipse.persistence.tools.mapping.orm.ExternalInstantiationCopyPolicy;
import org.eclipse.persistence.tools.mapping.orm.ExternalMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSql;
import org.eclipse.persistence.tools.mapping.orm.ExternalORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalStructConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.tests.AbstractExternalFormTests;
import org.eclipse.persistence.tools.mapping.tests.dom.orm.AccessMethodsTests;
import org.eclipse.persistence.tools.mapping.tests.dom.orm.AccessTypeTests;
import org.eclipse.persistence.tools.mapping.tests.dom.orm.ConverterTests;
import org.eclipse.persistence.tools.mapping.tests.dom.orm.ORMConfigurationTests;
import org.eclipse.persistence.tools.mapping.tests.dom.orm.PropertyTests;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.w3c.dom.Node;

public class EmbeddableTests<T extends ExternalEmbeddable>
extends AbstractExternalFormTests<T> {
    final AbstractExternalFormTests.ChildNodeTester<T, ExternalAccessMethods> buildAccessMethodsTester() {
        return AccessMethodsTests.buildAccessMethodsTester();
    }

    final AbstractExternalFormTests.AttributeNodeTester<T, AccessType> buildAccessTester() {
        return AccessTypeTests.buildAccessAttributeNodeTester();
    }

    final AbstractExternalFormTests.ChildListNodeTester<T, ExternalAssociationOverride, String> buildAssociationOverrideTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<T, ExternalAssociationOverride, String>(){

            @Override
            public ExternalAssociationOverride addChild(T form, String value) {
                return form.addAssociationOverride(value);
            }

            @Override
            public ExternalAssociationOverride getChild(T form, int index) {
                return form.getAssociationOverride(index);
            }

            @Override
            public ExternalAssociationOverride getChildForm(List<ExternalAssociationOverride> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalAssociationOverride> getChildren(T form) {
                return form.associationOverrides();
            }

            @Override
            public int getChildrenSize(T form) {
                return form.associationOverridesSize();
            }

            @Override
            public String getChildValue(ExternalAssociationOverride childForm) {
                return childForm.getName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "ASSOCIATION_OVERRIDE_1";
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "association-override";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(T form, int index) {
                form.removeAssociationOverride(index);
            }
        };
    }

    final AbstractExternalFormTests.ChildListNodeTester<T, ExternalAttributeOverride, String> buildAttributeOverrideTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<T, ExternalAttributeOverride, String>(){

            @Override
            public ExternalAttributeOverride addChild(T form, String value) {
                return form.addAttributeOverride(value);
            }

            @Override
            public ExternalAttributeOverride getChild(T form, int index) {
                return form.getAttributeOverride(index);
            }

            @Override
            public ExternalAttributeOverride getChildForm(List<ExternalAttributeOverride> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalAttributeOverride> getChildren(T form) {
                return form.attributeOverrides();
            }

            @Override
            public int getChildrenSize(T form) {
                return form.attributeOverridesSize();
            }

            @Override
            public String getChildValue(ExternalAttributeOverride childForm) {
                return childForm.getName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "ATTRIBUTE_OVERRIDE_1";
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "attribute-override";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(T form, int index) {
                form.removeAttributeOverride(index);
            }
        };
    }

    final AbstractExternalFormTests.ContainerChildListNodeTester<T, ExternalMapping, String> buildAttributesTester() {
        return new AbstractExternalFormTests.ContainerChildListNodeTester<T, ExternalMapping, String>(){
            private List<String> expectedValues;
            private List<String> mappingNames;
            private List<Integer> orderedIndices = new ArrayList<Integer>();
            private List<String> orderedValues = new ArrayList<String>();
            {
                this.mappingNames = this.buildMappingNames();
                this.expectedValues = this.buildExpectedValues();
            }

            @Override
            public ExternalMapping addChild(T form, String value) {
                String mappingName = value.substring(0, value.indexOf("_"));
                int index = this.insertionIndex(this.orderedValues, mappingName);
                this.orderedValues.add(index, value);
                this.adjustOrderedIndices(index, 1);
                this.orderedIndices.add(index);
                return this.addMapping(form, value, mappingName);
            }

            private ExternalMapping addMapping(T form, String value, String mappingName) {
                if ("basic".equals(mappingName)) {
                    return form.addBasicMapping(value);
                }
                if ("basic-collection".equals(mappingName)) {
                    return form.addBasicCollectionMapping(value);
                }
                if ("basic-map".equals(mappingName)) {
                    return form.addBasicMapMapping(value);
                }
                if ("many-to-one".equals(mappingName)) {
                    return form.addManyToOneMapping(value);
                }
                if ("one-to-many".equals(mappingName)) {
                    return form.addOneToManyMapping(value);
                }
                if ("one-to-one".equals(mappingName)) {
                    return form.addOneToOneMapping(value);
                }
                if ("many-to-many".equals(mappingName)) {
                    return form.addManyToManyMapping(value);
                }
                if ("element-collection".equals(mappingName)) {
                    return form.addElementCollectionMapping(value);
                }
                if ("embedded".equals(mappingName)) {
                    return form.addEmbeddedMapping(value);
                }
                if ("transient".equals(mappingName)) {
                    return form.addTransientMapping(value);
                }
                throw new IllegalAccessError("The value is unknown: " + value);
            }

            private void adjustOrderedIndices(int index, int direction) {
                int position = 0;
                int count = this.orderedIndices.size();
                while (position < count) {
                    int value = this.orderedIndices.get(position);
                    if (value >= index) {
                        this.orderedIndices.set(position, value + direction);
                    }
                    ++position;
                }
            }

            private List<String> buildExpectedValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 3) {
                    for (String mappingName : this.mappingNames) {
                        values.add(String.valueOf(mappingName) + "_" + index);
                    }
                    ++index;
                }
                Collections.shuffle(values);
                return values;
            }

            private List<String> buildMappingNames() {
                ArrayList<String> names = new ArrayList<String>();
                names.add("basic");
                names.add("basic-collection");
                names.add("basic-map");
                names.add("many-to-one");
                names.add("one-to-many");
                names.add("one-to-one");
                names.add("many-to-many");
                names.add("element-collection");
                names.add("embedded");
                names.add("transient");
                return names;
            }

            @Override
            public ExternalMapping getChild(T form, int index) {
                index = this.orderedIndices.get(index);
                return form.getMapping(index);
            }

            @Override
            public ExternalMapping getChildForm(List<ExternalMapping> childForms, int index) {
                index = this.orderedIndices.get(index);
                return childForms.get(index);
            }

            @Override
            public List<ExternalMapping> getChildren(T form) {
                return form.mappings();
            }

            @Override
            public int getChildrenSize(T form) {
                return form.mappingsSize();
            }

            @Override
            public String getChildValue(ExternalMapping childForm) {
                return childForm.getName();
            }

            @Override
            public String getContainerNodeName() {
                return "attributes";
            }

            @Override
            public String getExpectedChildValue(int index) {
                return this.expectedValues.get(index);
            }

            @Override
            public List<String> getExpectedChildValues() {
                return this.expectedValues;
            }

            @Override
            public String getNodeName() {
                return "attributes";
            }

            @Override
            public List<String> getNodeNames() {
                ArrayList<String> names = new ArrayList<String>();
                names.add("description");
                names.add("id");
                names.add("embedded-id");
                names.add("basic");
                names.add("basic-collection");
                names.add("basic-map");
                names.add("version");
                names.add("many-to-one");
                names.add("one-to-many");
                names.add("one-to-one");
                names.add("variable-one-to-one");
                names.add("many-to-many");
                names.add("element-collection");
                names.add("embedded");
                names.add("transformation");
                names.add("transient");
                names.add("structure");
                names.add("array");
                return names;
            }

            private int insertionIndex(List<String> values, String mappingType) {
                int mappingTypeIndex = this.mappingNames.indexOf(mappingType);
                int index = 0;
                while (index < values.size()) {
                    String value = values.get(index);
                    String type = value.substring(0, value.indexOf("_"));
                    int otherMappingTypeIndex = this.mappingNames.indexOf(type);
                    if (mappingTypeIndex < otherMappingTypeIndex) {
                        return index;
                    }
                    ++index;
                }
                return values.size();
            }

            @Override
            public void removeChild(T form, int index) {
                index = this.orderedIndices.remove(index);
                this.orderedValues.remove(index);
                form.removeMapping(index);
                this.adjustOrderedIndices(index, -1);
            }
        };
    }

    final AbstractExternalFormTests.ChildAttributeTester<T, ChangeTrackingType> buildChangeTrackingTester() {
        return new AbstractExternalFormTests.ChildAttributeTester<T, ChangeTrackingType>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getChildNodeName() {
                return "change-tracking";
            }

            @Override
            public ChangeTrackingType getDefaultValue() {
                return ChangeTrackingType.AUTO;
            }

            @Override
            public String getNodeName() {
                return "type";
            }

            @Override
            public ChangeTrackingType getValue(T form) {
                return form.getChangeTrackingType();
            }

            @Override
            public ChangeTrackingType getValue1() {
                return ChangeTrackingType.ATTRIBUTE;
            }

            @Override
            public ChangeTrackingType getValue2() {
                return ChangeTrackingType.DEFERRED;
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, ChangeTrackingType value) {
                form.setChangeTrackingType(value);
            }

            @Override
            public String toString(ChangeTrackingType value) {
                return value.name();
            }
        };
    }

    final AbstractExternalFormTests.AttributeNodeTester<T, String> buildClassTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<T, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return true;
            }

            @Override
            public String getDefaultValue() {
                return EmbeddableTests.this.defaultClassName();
            }

            @Override
            public String getNodeName() {
                return "class";
            }

            @Override
            public String getValue(T form) {
                return form.getClassName();
            }

            @Override
            public String getValue1() {
                return "org.test.Embeddable_1";
            }

            @Override
            public String getValue2() {
                return "org.test.Embeddable_2";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return false;
            }

            @Override
            public void setValue(T form, String value) {
                form.setClassName(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    final AbstractExternalFormTests.ChildNodeTester<T, ExternalCloneCopyPolicy> buildCloneCopyPolicyTester() {
        return new AbstractExternalFormTests.ChildNodeTester<T, ExternalCloneCopyPolicy>(){

            @Override
            public ExternalCloneCopyPolicy addChild(T form) {
                return form.addCloneCopyPolicy();
            }

            @Override
            public ExternalCloneCopyPolicy getChild(T form) {
                return form.getCloneCopyPolicy();
            }

            @Override
            public String getNodeName() {
                return "clone-copy-policy";
            }

            @Override
            public boolean hasChild(T form) {
                return form.hasCloneCopyPolicy();
            }

            @Override
            public void removeChild(T form) {
                form.removeCloneCopyPolicy();
            }
        };
    }

    final AbstractExternalFormTests.ChildListNodeTester<T, ExternalClassConverter, String> buildConverterTester() {
        return ConverterTests.buildConverterTester();
    }

    final AbstractExternalFormTests.ChildNodeTester<T, ExternalCopyPolicy> buildCopyPolicyTester() {
        return new AbstractExternalFormTests.ChildNodeTester<T, ExternalCopyPolicy>(){

            @Override
            public ExternalCopyPolicy addChild(T form) {
                return form.addCopyPolicy();
            }

            @Override
            public ExternalCopyPolicy getChild(T form) {
                return form.getCopyPolicy();
            }

            @Override
            public String getNodeName() {
                return "copy-policy";
            }

            @Override
            public boolean hasChild(T form) {
                return form.hasCopyPolicy();
            }

            @Override
            public void removeChild(T form) {
                form.removeCopyPolicy();
            }
        };
    }

    final AbstractExternalFormTests.ChildAttributeTester<T, String> buildCustomizerTester() {
        return new AbstractExternalFormTests.ChildAttributeTester<T, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getChildNodeName() {
                return "customizer";
            }

            @Override
            public String getDefaultValue() {
                return "org.default.MyCustomizer";
            }

            @Override
            public String getNodeName() {
                return "class";
            }

            @Override
            public String getValue(T form) {
                return form.getCustomizerClassName();
            }

            @Override
            public String getValue1() {
                return "org.test.Customizer1";
            }

            @Override
            public String getValue2() {
                return "org.test.Customizer2";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, String value) {
                form.setCustomizerClassName(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    final AbstractExternalFormTests.TextNodeTester<T, String> buildDescriptionTester() {
        return new AbstractExternalFormTests.TextNodeTester<T, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getDefaultValue() {
                return "test default";
            }

            @Override
            public String getNodeName() {
                return "description";
            }

            @Override
            public String getValue(T form) {
                return form.getDescription();
            }

            @Override
            public String getValue1() {
                return "testing embeddable";
            }

            @Override
            public String getValue2() {
                return "something else";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, String value) {
                form.setDescription(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    final AbstractExternalFormTests.ExternalFormBuilder<T> buildEmbeddableBuilder() {
        return new AbstractExternalFormTests.ExternalFormBuilder<T>(){

            @Override
            public T buildExternalForm() throws IOException {
                ORMConfiguration orm = ORMConfigurationTests.buildExternalForm();
                return orm.addEmbeddable(EmbeddableTests.this.defaultClassName());
            }

            @Override
            public T buildExternalForm(ExternalForm parentForm) {
                return ((ExternalORMConfiguration)parentForm).addEmbeddable(EmbeddableTests.this.defaultClassName());
            }

            @Override
            public int getDefaultAttributeCount() {
                return 1;
            }

            @Override
            public Node getNode(T form) {
                return (Node)ObjectTools.execute(form, (String)"getElement");
            }

            @Override
            public String getNodeName() {
                return "embeddable";
            }

            @Override
            public List<String> getTreeNodeNames() {
                return ListTools.list((Object[])new String[]{"entity-mappings", "embeddable"});
            }
        };
    }

    final AbstractExternalFormTests.ChildNodeTester<T, ExternalInstantiationCopyPolicy> buildInstantiationCopyPolicyTester() {
        return new AbstractExternalFormTests.ChildNodeTester<T, ExternalInstantiationCopyPolicy>(){

            @Override
            public ExternalInstantiationCopyPolicy addChild(T form) {
                return form.addInstantiationCopyPolicy();
            }

            @Override
            public ExternalInstantiationCopyPolicy getChild(T form) {
                return form.getInstantiationCopyPolicy();
            }

            @Override
            public String getNodeName() {
                return "instantiation-copy-policy";
            }

            @Override
            public boolean hasChild(T form) {
                return form.hasInstantiationCopyPolicy();
            }

            @Override
            public void removeChild(T form) {
                form.removeInstantiationCopyPolicy();
            }
        };
    }

    final AbstractExternalFormTests.AttributeNodeTester<T, Boolean> buildMetadataCompleteTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<T, Boolean>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public Boolean getDefaultValue() {
                return Boolean.TRUE;
            }

            @Override
            public String getNodeName() {
                return "metadata-complete";
            }

            @Override
            public Boolean getValue(T form) {
                return form.isMetadataComplete();
            }

            @Override
            public Boolean getValue1() {
                return Boolean.TRUE;
            }

            @Override
            public Boolean getValue2() {
                return Boolean.FALSE;
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, Boolean value) {
                form.setMetadataComplete(value);
            }

            @Override
            public String toString(Boolean value) {
                return value.toString();
            }
        };
    }

    final AbstractExternalFormTests.ChildNodeTester<T, ExternalNoSql> buildNoSqlTester() {
        return new AbstractExternalFormTests.ChildNodeTester<T, ExternalNoSql>(){

            @Override
            public ExternalNoSql addChild(T form) {
                return form.addNoSql();
            }

            @Override
            public ExternalNoSql getChild(T form) {
                return form.getNoSql();
            }

            @Override
            public String getNodeName() {
                return "no-sql";
            }

            @Override
            public boolean hasChild(T form) {
                return form.hasNoSql();
            }

            @Override
            public void removeChild(T form) {
                form.removeNoSql();
            }
        };
    }

    final AbstractExternalFormTests.ChildListNodeTester<T, ExternalObjectTypeConverter, String> buildObjectTypeConverterTester() {
        return ConverterTests.buildObjectTypeConverterTester();
    }

    final String buildOracleArrayTester() {
        return "oracle-array";
    }

    final String buildOracleObjectTester() {
        return "oracle-object";
    }

    final AbstractExternalFormTests.AttributeNodeTester<T, String> buildParentClassTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<T, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getDefaultValue() {
                return "org.parent.ParentClass";
            }

            @Override
            public String getNodeName() {
                return "parent-class";
            }

            @Override
            public String getValue(T form) {
                return form.getParentClassName();
            }

            @Override
            public String getValue1() {
                return "org.test.ParentClass1";
            }

            @Override
            public String getValue2() {
                return "org.test.ParentClass2";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, String value) {
                form.setParentClassName(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    final String buildPlsqlRecordTester() {
        return "plsql-record";
    }

    final String buildPlsqlTableTester() {
        return "plsql-table";
    }

    final AbstractExternalFormTests.ChildListNodeTester<T, ExternalProperty, String> buildPropertyTester() {
        return PropertyTests.buildPropertyTester();
    }

    final String buildSerializedConverterTester() {
        return ConverterTests.buildSerializedConverterTester();
    }

    final AbstractExternalFormTests.ChildListNodeTester<T, ExternalStructConverter, String> buildStructConverterTester() {
        return ConverterTests.buildStructConverterTester();
    }

    final String buildStructTester() {
        return "struct";
    }

    final AbstractExternalFormTests.ChildListNodeTester<T, ExternalTypeConverter, String> buildTypeConverterTester() {
        return ConverterTests.buildTypeConverterTester();
    }

    String defaultClassName() {
        return "org.eclipse.persistence.tool.mappings.tests.Embeddable";
    }

    @Override
    protected void populate(AbstractExternalFormTests.RootNodeTester tester) {
        tester.setBuilder(this.buildEmbeddableBuilder());
        tester.addAttribute(this.buildClassTester());
        tester.addAttribute(this.buildParentClassTester());
        tester.addAttribute(this.buildAccessTester());
        tester.addAttribute(this.buildMetadataCompleteTester());
        tester.addTextNode(this.buildDescriptionTester());
        tester.addNode(this.buildAccessMethodsTester());
        tester.addChildAttribute(this.buildCustomizerTester());
        tester.addChildAttribute(this.buildChangeTrackingTester());
        tester.addUnsupportedNode(this.buildStructTester());
        tester.addNode(this.buildNoSqlTester());
        tester.addListNodes(this.buildConverterTester());
        tester.addListNodes(this.buildTypeConverterTester());
        tester.addListNodes(this.buildObjectTypeConverterTester());
        tester.addUnsupportedAttribute(this.buildSerializedConverterTester());
        tester.addListNodes(this.buildStructConverterTester());
        tester.addNode(this.buildCopyPolicyTester());
        tester.addNode(this.buildInstantiationCopyPolicyTester());
        tester.addNode(this.buildCloneCopyPolicyTester());
        tester.addUnsupportedNode(this.buildOracleObjectTester());
        tester.addUnsupportedNode(this.buildOracleArrayTester());
        tester.addUnsupportedNode(this.buildPlsqlRecordTester());
        tester.addUnsupportedNode(this.buildPlsqlTableTester());
        tester.addListNodes(this.buildPropertyTester());
        tester.addListNodes(this.buildAttributeOverrideTester());
        tester.addListNodes(this.buildAssociationOverrideTester());
        tester.addContainerListNodes(this.buildAttributesTester());
    }
}

