/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalNamedStoredProcedureQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalStoredProcedureParameter;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractQuery;
import org.eclipse.persistence.tools.mapping.orm.dom.StoredProcedureParameter;
import org.eclipse.persistence.tools.utility.TextRange;

final class NamedStoredProcedureQuery
extends AbstractQuery
implements ExternalNamedStoredProcedureQuery {
    NamedStoredProcedureQuery(AbstractExternalForm parent, int index) {
        super(parent, index);
    }

    @Override
    public ExternalStoredProcedureParameter addParameter() {
        StoredProcedureParameter parameter = this.buildParameter(-1);
        parameter.addSelf();
        return parameter;
    }

    @Override
    public void addResultClassName(String name) {
        this.addChildTextNode("result-class", name);
    }

    @Override
    public void addResultSetMapping(String mapping) {
        this.addChildTextNode("result-set-mapping", mapping);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("result-class");
        names.add("result-set-mapping");
        names.add("procedure-name");
        names.add("returns-result-set");
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("description");
        return names;
    }

    private StoredProcedureParameter buildParameter(int index) {
        return new StoredProcedureParameter(this, index);
    }

    @Override
    public Boolean doesReturnResultSet() {
        return this.getBooleanAttribute("returns-result-set");
    }

    @Override
    protected String getElementName() {
        return "named-stored-procedure-query";
    }

    @Override
    public ExternalStoredProcedureParameter getParameter(int index) {
        if (this.hasChild("parameter", index)) {
            return this.buildParameter(index);
        }
        return null;
    }

    @Override
    public String getProcedureName() {
        return this.getAttribute("procedure-name");
    }

    @Override
    public TextRange getProcedureNameTextRange() {
        return this.getAttributeTextRange("procedure-name");
    }

    @Override
    public String getResultClassName(int index) {
        return this.getChildTextNode("result-class", index);
    }

    @Override
    public String getResultSetMapping(int index) {
        return this.getChildTextNode("result-set-mapping", index);
    }

    @Override
    public TextRange getResultSetMappingTextRange(int index) {
        return this.getChildTextNodeTextRange("result-set-mapping", index);
    }

    @Override
    public TextRange getReturnResultSetTextRange() {
        return this.getAttributeTextRange("returns-result-set");
    }

    @Override
    public List<ExternalStoredProcedureParameter> parameters() {
        int count = this.parametersSize();
        ArrayList<ExternalStoredProcedureParameter> parameters = new ArrayList<ExternalStoredProcedureParameter>(count);
        int index = 0;
        while (index < count) {
            parameters.add(this.buildParameter(index));
            ++index;
        }
        return parameters;
    }

    @Override
    public int parametersSize() {
        return this.getChildrenSize("parameter");
    }

    @Override
    public void removeParameter(int index) {
        StoredProcedureParameter parameter = this.buildParameter(-1);
        parameter.removeSelf();
    }

    @Override
    public void removeResultClassName(int index) {
        this.removeChild("result-class", index);
    }

    @Override
    public void removeResultSetMapping(int index) {
        this.removeChild("result-set-mapping", index);
    }

    @Override
    public List<String> resultClassNames() {
        int count = this.resultClassNameSize();
        ArrayList<String> resultClassNames = new ArrayList<String>(count);
        int index = 0;
        while (index < count) {
            resultClassNames.add(this.getResultClassName(index));
            ++index;
        }
        return resultClassNames;
    }

    @Override
    public int resultClassNameSize() {
        return this.getChildrenSize("result-class");
    }

    @Override
    public List<String> resultSetMappings() {
        int count = this.resultSetMappingsSize();
        ArrayList<String> resultSetMappings = new ArrayList<String>(count);
        int index = 0;
        while (index < count) {
            resultSetMappings.add(this.getResultSetMapping(index));
            ++index;
        }
        return resultSetMappings;
    }

    @Override
    public int resultSetMappingsSize() {
        return this.getChildrenSize("result-set-mapping");
    }

    @Override
    public void setDoesReturnResultSet(Boolean returnResultSet) {
        this.setAttribute("returns-result-set", returnResultSet);
    }

    @Override
    public void setProcedureName(String name) {
        this.setAttribute("procedure-name", name);
    }
}

