/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalConversionValue;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.ConversionValue;
import org.eclipse.persistence.tools.utility.TextRange;

final class ObjectTypeConverter
extends AbstractConverter
implements ExternalObjectTypeConverter {
    ObjectTypeConverter(AbstractExternalForm parent, int index) {
        super(parent, index);
    }

    @Override
    public ExternalConversionValue addConversionValue() {
        ConversionValue conversionValue = this.buildConversionValue(-1);
        conversionValue.addSelf();
        return conversionValue;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("data-type");
        names.add("object-type");
        return names;
    }

    private ConversionValue buildConversionValue(int index) {
        return new ConversionValue(this, index);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("conversion-value");
        names.add("default-object-value");
        return names;
    }

    @Override
    public List<ExternalConversionValue> conversionValues() {
        int count = this.conversionValuesSize();
        ArrayList<ExternalConversionValue> conversionValues = new ArrayList<ExternalConversionValue>(count);
        int index = 0;
        while (index < count) {
            conversionValues.add(this.buildConversionValue(index));
            ++index;
        }
        return conversionValues;
    }

    @Override
    public int conversionValuesSize() {
        return this.getChildrenSize("conversion-value");
    }

    @Override
    public ExternalConversionValue getConversionValue(int index) {
        if (this.hasChild("conversion-value", index)) {
            return this.buildConversionValue(index);
        }
        return null;
    }

    @Override
    public String getDatatype() {
        return this.getAttribute("data-type");
    }

    @Override
    public TextRange getDatatypeTextRange() {
        return this.getAttributeTextRange("data-type");
    }

    @Override
    public String getDefaultValue() {
        return this.getChildTextNode("default-object-value");
    }

    @Override
    public TextRange getDefaultValueTextRange() {
        return this.getChildTextNodeTextRange("default-object-value");
    }

    @Override
    protected String getElementName() {
        return "object-type-converter";
    }

    @Override
    public String getObjecttype() {
        return this.getAttribute("object-type");
    }

    @Override
    public TextRange getObjecttypeTextRange() {
        return this.getAttributeTextRange("object-type");
    }

    @Override
    public void removeAllConversionValue() {
        this.removeChildren("conversion-value");
    }

    @Override
    public void removeConversionValue(int index) {
        ConversionValue conversionValue = this.buildConversionValue(index);
        conversionValue.removeSelf();
    }

    @Override
    public void setDatatype(String datatypeName) {
        this.setAttribute("data-type", datatypeName);
    }

    @Override
    public void setDefaultValue(String value) {
        this.updateChildTextNode("default-object-value", value);
    }

    @Override
    public void setObjecttype(String objecttypeName) {
        this.setAttribute("object-type", objecttypeName);
    }
}

