/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappingVisitor;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.ExternalOneToOneMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalPrimaryKeyJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.Embeddable;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.dom.PrimaryKeyJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.RelationshipMapping;
import org.eclipse.persistence.tools.utility.TextRange;

final class OneToOneMapping
extends RelationshipMapping
implements ExternalOneToOneMapping {
    OneToOneMapping(Embeddable parent) {
        super(parent);
    }

    @Override
    public void accept(ExternalMappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ExternalJoinColumn addJoinColumn(String name) {
        JoinColumn joinColumn = this.buildJoinColumn(-1);
        joinColumn.addSelf();
        joinColumn.setName(name);
        return joinColumn;
    }

    @Override
    public ExternalNoSqlJoinField addJoinField(String name) {
        NoSqlJoinField joinField = this.buildJoinField(-1);
        joinField.addSelf();
        joinField.setName(name);
        return joinField;
    }

    @Override
    public ExternalPrimaryKeyJoinColumn addPrimaryKeyJoinColumn(String name) {
        PrimaryKeyJoinColumn pkJoinColumn = this.buildPrimaryKeyJoinColumn(-1);
        pkJoinColumn.addSelf();
        pkJoinColumn.setName(name);
        return pkJoinColumn;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("target-entity");
        names.add("fetch");
        names.add("optional");
        names.add("access");
        names.add("mapped-by-id");
        names.add("orphan-removal");
        names.add("maps-id");
        names.add("id");
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("primary-key-join-column");
        names.add("join-column");
        names.add("join-table");
        names.add("cascade");
        names.add("private-owned");
        names.add("join-fetch");
        names.add("batch-fetch");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private JoinColumn buildJoinColumn(int index) {
        return new JoinColumn(this, "join-column", index);
    }

    private NoSqlJoinField buildJoinField(int index) {
        return new NoSqlJoinField(this, index);
    }

    private PrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(int index) {
        return new PrimaryKeyJoinColumn(this, index);
    }

    @Override
    protected String getElementName() {
        return "one-to-one";
    }

    @Override
    public Boolean getId() {
        return this.getBooleanAttribute("id");
    }

    @Override
    public TextRange getIdTextRange() {
        return this.getAttributeTextRange("id");
    }

    @Override
    public ExternalJoinColumn getJoinColumn(int index) {
        if (this.hasChild("join-column", index)) {
            return this.buildJoinColumn(index);
        }
        return null;
    }

    @Override
    public String getMappedByMappingName() {
        return this.getAttribute("mapped-by-id");
    }

    @Override
    public TextRange getMappedByMappingNameTextRange() {
        return this.getAttributeTextRange("mapped-by-id");
    }

    @Override
    public String getMapsId() {
        return this.getAttribute("maps-id");
    }

    @Override
    public TextRange getMapsIdTextRange() {
        return this.getAttributeTextRange("maps-id");
    }

    @Override
    public TextRange getOrphanRemovalTextRange() {
        return this.getAttributeTextRange("orphan-removal");
    }

    @Override
    public ExternalPrimaryKeyJoinColumn getPrimaryKeyJoinColumn(int index) {
        if (this.hasChild("primary-key-join-column", index)) {
            return this.buildPrimaryKeyJoinColumn(index);
        }
        return null;
    }

    @Override
    public TextRange getPrivateOwnedTextRange() {
        return this.getChildTextRange("private-owned");
    }

    @Override
    public Boolean isOrphanRemoval() {
        return this.getBooleanAttribute("orphan-removal");
    }

    @Override
    public Boolean isPrivateOwned() {
        return this.hasChild("private-owned");
    }

    @Override
    public List<ExternalJoinColumn> joinColumns() {
        int count = this.joinColumnsSize();
        ArrayList<ExternalJoinColumn> joinColumns = new ArrayList<ExternalJoinColumn>(count);
        int index = 0;
        while (index < count) {
            joinColumns.add(this.buildJoinColumn(index));
            ++index;
        }
        return joinColumns;
    }

    @Override
    public int joinColumnsSize() {
        return this.getChildrenSize("join-column");
    }

    @Override
    public List<ExternalNoSqlJoinField> joinFields() {
        int count = this.joinFieldSize();
        ArrayList<ExternalNoSqlJoinField> joinFields = new ArrayList<ExternalNoSqlJoinField>(count);
        int index = 0;
        while (index < count) {
            joinFields.add(this.buildJoinField(index));
            ++index;
        }
        return joinFields;
    }

    @Override
    public int joinFieldSize() {
        return this.getChildrenSize("join-field");
    }

    @Override
    public List<ExternalPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        int count = this.primaryKeyJoinColumnsSize();
        ArrayList<ExternalPrimaryKeyJoinColumn> pkJoinColumns = new ArrayList<ExternalPrimaryKeyJoinColumn>(count);
        int index = 0;
        while (index < count) {
            pkJoinColumns.add(this.buildPrimaryKeyJoinColumn(index));
            ++index;
        }
        return pkJoinColumns;
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.getChildrenSize("primary-key-join-column");
    }

    @Override
    public void removeJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.removeSelf();
    }

    @Override
    public void removeJoinField(int index) {
        this.removeChild("join-field", index);
    }

    @Override
    public void removePrimaryKeyJoinColumn(int index) {
        PrimaryKeyJoinColumn pkJoinColumn = this.buildPrimaryKeyJoinColumn(index);
        pkJoinColumn.removeSelf();
    }

    @Override
    public void setId(Boolean id) {
        this.setAttribute("id", id);
    }

    @Override
    public void setMappedByMappingName(String name) {
        this.setAttribute("mapped-by-id", name);
    }

    @Override
    public void setMapsId(String mapsId) {
        this.setAttribute("maps-id", mapsId);
    }

    @Override
    public void setOrphanRemoval(Boolean removeOrphans) {
        this.setAttribute("orphan-removal", removeOrphans);
    }

    @Override
    public void setPrivateOwned(Boolean privateOwned) {
        if (privateOwned == Boolean.TRUE) {
            this.addChild("private-owned");
        } else {
            this.removeChild("private-owned");
        }
    }
}

