/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.OptimisticLockingType;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalOptimisticLocking;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.MappedSuperclass;
import org.eclipse.persistence.tools.utility.TextRange;

final class OptimisticLocking
extends AbstractExternalForm
implements ExternalOptimisticLocking {
    OptimisticLocking(MappedSuperclass parent) {
        super(parent);
    }

    @Override
    public ExternalEntityColumn addColumn(String columnName) {
        EntityColumn column = this.buildColumn(-1);
        column.addSelf();
        column.setName(columnName);
        return column;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("type");
        names.add("cascade");
        return names;
    }

    private EntityColumn buildColumn(int index) {
        return new EntityColumn(this, "selected-column", index);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("selected-column");
        return names;
    }

    @Override
    public List<ExternalEntityColumn> columns() {
        int count = this.columnsSize();
        ArrayList<ExternalEntityColumn> columns = new ArrayList<ExternalEntityColumn>(count);
        int index = 0;
        while (index < count) {
            columns.add(this.buildColumn(index));
            ++index;
        }
        return columns;
    }

    @Override
    public int columnsSize() {
        return this.getChildrenSize("selected-column");
    }

    @Override
    public TextRange getCascadeTextRange() {
        return this.getAttributeTextRange("cascade");
    }

    @Override
    public ExternalEntityColumn getColumn(int index) {
        if (this.hasChild("selected-column", index)) {
            return this.buildColumn(index);
        }
        return null;
    }

    @Override
    public TextRange getColumnTextRange(String columnName) {
        for (ExternalEntityColumn column : this.columns()) {
            if (!columnName.equals(column.getName())) continue;
            return column.getTextRange();
        }
        return null;
    }

    @Override
    protected String getElementName() {
        return "optimistic-locking";
    }

    @Override
    public OptimisticLockingType getOptimisticLockingType() {
        return this.getEnumAttribute("type", OptimisticLockingType.class);
    }

    @Override
    public TextRange getOptimisticLockingTypeTextRange() {
        return this.getAttributeTextRange("type");
    }

    @Override
    public void removeAllColumns() {
        this.removeChildren("selected-column");
    }

    @Override
    public void removeColumn(int index) {
        EntityColumn column = this.buildColumn(index);
        column.removeSelf();
    }

    @Override
    public void setOptimisticLockingType(OptimisticLockingType type) {
        if (type == null) {
            if (!this.hasAnyChildren()) {
                this.removeSelf();
            } else {
                this.setAttribute("type", (Enum<?>)type);
            }
        } else {
            this.setAttribute("type", (Enum<?>)type);
        }
    }

    @Override
    public void setShouldCascade(Boolean value) {
        this.setAttribute("cascade", value);
    }

    @Override
    public Boolean shouldCascade() {
        return this.getBooleanAttribute("cascade");
    }
}

