/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.tools.mapping.orm.ExternalBatchFetch;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalRelationshipMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.BatchFetch;
import org.eclipse.persistence.tools.mapping.orm.dom.Embeddable;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinTable;
import org.eclipse.persistence.tools.mapping.orm.dom.NonTransientMapping;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

abstract class RelationshipMapping
extends NonTransientMapping
implements ExternalRelationshipMapping {
    private List<String> cascadeTypeIndices;

    RelationshipMapping(Embeddable parent) {
        super(parent);
    }

    @Override
    public final void addBatchFetch() {
        BatchFetch batchFetch = this.buildBatchFetch();
        batchFetch.addSelf();
    }

    @Override
    public final void addCascadeType(CascadeType type) {
        Element element = this.getChild("cascade");
        if (element == null) {
            element = this.addChild("cascade");
        }
        this.addChild(element, this.cascadeType(type), this.cascadeTypeIndices);
    }

    @Override
    public final ExternalJoinTable addJoinTable() {
        JoinTable joinTable = this.buildJoinTable();
        joinTable.addSelf();
        return joinTable;
    }

    private BatchFetch buildBatchFetch() {
        return new BatchFetch(this);
    }

    private List<String> buildCascadeTypeIndices() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("cascade-all");
        names.add("cascade-persist");
        names.add("cascade-merge");
        names.add("cascade-remove");
        names.add("cascade-refresh");
        names.add("cascade-detach");
        return names;
    }

    private JoinTable buildJoinTable() {
        return new JoinTable(this);
    }

    private String cascadeType(CascadeType type) {
        switch (type) {
            case ALL: {
                return "cascade-all";
            }
            case DETACH: {
                return "cascade-detach";
            }
            case MERGE: {
                return "cascade-merge";
            }
            case PERSIST: {
                return "cascade-persist";
            }
            case REFRESH: {
                return "cascade-refresh";
            }
            case REMOVE: {
                return "cascade-remove";
            }
        }
        return null;
    }

    private CascadeType cascadeType(Element element) {
        String elementName = this.getNodeName(element);
        if (ObjectTools.equals((Object)elementName, (Object)"cascade-all")) {
            return CascadeType.ALL;
        }
        if (ObjectTools.equals((Object)elementName, (Object)"cascade-detach")) {
            return CascadeType.DETACH;
        }
        if (ObjectTools.equals((Object)elementName, (Object)"cascade-merge")) {
            return CascadeType.MERGE;
        }
        if (ObjectTools.equals((Object)elementName, (Object)"cascade-persist")) {
            return CascadeType.PERSIST;
        }
        if (ObjectTools.equals((Object)elementName, (Object)"cascade-refresh")) {
            return CascadeType.REFRESH;
        }
        if (ObjectTools.equals((Object)elementName, (Object)"cascade-remove")) {
            return CascadeType.REMOVE;
        }
        return null;
    }

    @Override
    public final List<CascadeType> cascadeTypes() {
        Element element = this.getChild("cascade");
        if (!this.hasChild("cascade")) {
            return Collections.emptyList();
        }
        List<Element> children = this.getChildren(element);
        ArrayList<CascadeType> cascadeTypes = new ArrayList<CascadeType>(children.size());
        for (Element childElement : children) {
            CascadeType cascadeType = this.cascadeType(childElement);
            if (cascadeType == null) continue;
            cascadeTypes.add(cascadeType);
        }
        return cascadeTypes;
    }

    @Override
    public final ExternalBatchFetch getBatchFetch() {
        if (this.hasChild("batch-fetch")) {
            return this.buildBatchFetch();
        }
        return null;
    }

    @Override
    public final TextRange getCascadeTypeTextRange() {
        return this.getChildTextRange("cascade");
    }

    @Override
    public final FetchType getFetchType() {
        return this.getEnumAttribute("fetch", FetchType.class);
    }

    @Override
    public final TextRange getFetchTypeTextRange() {
        return this.getAttributeTextRange("fetch");
    }

    @Override
    public final JoinFetchType getJoinFetchType() {
        return this.getChildEnumNode("join-fetch", JoinFetchType.class);
    }

    @Override
    public final TextRange getJoinFetchTypeTextRange() {
        return this.getChildTextNodeTextRange("join-fetch");
    }

    @Override
    public final ExternalJoinTable getJoinTable() {
        if (this.hasChild("join-table")) {
            return this.buildJoinTable();
        }
        return null;
    }

    @Override
    public final TextRange getOptionalTextRange() {
        return this.getAttributeTextRange("optional");
    }

    @Override
    public final String getTargetEntityName() {
        return this.getAttribute("target-entity");
    }

    @Override
    public final TextRange getTargetEntityNameTextRange() {
        return this.getAttributeTextRange("target-entity");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.cascadeTypeIndices = this.buildCascadeTypeIndices();
    }

    @Override
    public final Boolean isOptional() {
        return this.getBooleanAttribute("optional");
    }

    @Override
    public final void removeBatchFetch() {
        this.removeChild("batch-fetch");
    }

    @Override
    public final void removeCascadeType(CascadeType type) {
        Element element = this.getChild("cascade");
        if (element != null) {
            this.removeChild(element, this.cascadeType(type));
            if (!this.hasAnyChildren(element)) {
                this.remove(element);
            }
        }
    }

    @Override
    public final void removeJoinTable() {
        Element element = this.getChild("join-table");
        if (element != null) {
            this.remove(element);
        }
    }

    @Override
    public final void setFetchType(FetchType type) {
        this.setAttribute("fetch", (Enum<?>)type);
    }

    @Override
    public final void setJoinFetchType(JoinFetchType type) {
        this.updateChildTextNode("join-fetch", (Enum<?>)type);
    }

    @Override
    public final void setOptional(Boolean optional) {
        this.setAttribute("optional", optional);
    }

    @Override
    public final void setTargetEntityName(String entityName) {
        this.setAttribute("target-entity", entityName);
    }
}

