/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.FetchType;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappingVisitor;
import org.eclipse.persistence.tools.mapping.orm.ExternalReadTransformer;
import org.eclipse.persistence.tools.mapping.orm.ExternalTransformationMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalTransformer;
import org.eclipse.persistence.tools.mapping.orm.ExternalWriteTransformer;
import org.eclipse.persistence.tools.mapping.orm.dom.Embeddable;
import org.eclipse.persistence.tools.mapping.orm.dom.NonTransientMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.ReadTransformer;
import org.eclipse.persistence.tools.mapping.orm.dom.WriteTransfomer;
import org.eclipse.persistence.tools.utility.TextRange;

final class TransformationMapping
extends NonTransientMapping
implements ExternalTransformationMapping {
    TransformationMapping(Embeddable parent) {
        super(parent);
    }

    @Override
    public void accept(ExternalMappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ExternalTransformer addReadTransformer() {
        ReadTransformer transformer = this.buildReadTransformer();
        transformer.addSelf();
        return transformer;
    }

    @Override
    public ExternalWriteTransformer addWriteTransformer() {
        WriteTransfomer writeTransformer = this.buildWriteTransformer(-1);
        writeTransformer.addSelf();
        return writeTransformer;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("fetch");
        names.add("optional");
        names.add("access");
        names.add("mutable");
        names.add("attribute-type");
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("read-transformer");
        names.add("write-transformer");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private ReadTransformer buildReadTransformer() {
        return new ReadTransformer(this);
    }

    private WriteTransfomer buildWriteTransformer(int index) {
        return new WriteTransfomer(this, index);
    }

    @Override
    protected String getElementName() {
        return "transformation";
    }

    @Override
    public FetchType getFetchType() {
        return this.getEnumAttribute("fetch", FetchType.class);
    }

    @Override
    public TextRange getFetchTypeTextRange() {
        return this.getAttributeTextRange("fetch");
    }

    @Override
    public TextRange getMutableTextRange() {
        return this.getAttributeTextRange("mutable");
    }

    @Override
    public TextRange getOptionalTextRange() {
        return this.getAttributeTextRange("optional");
    }

    @Override
    public ExternalReadTransformer getReadTransformer() {
        if (this.hasChild("read-transformer")) {
            return this.buildReadTransformer();
        }
        return null;
    }

    @Override
    public ExternalWriteTransformer getWriteTransformer(int index) {
        if (this.hasChild("write-transformer", index)) {
            return this.buildWriteTransformer(index);
        }
        return null;
    }

    @Override
    public Boolean isMutable() {
        return this.getBooleanAttribute("mutable");
    }

    @Override
    public Boolean isOptional() {
        return this.getBooleanAttribute("optional");
    }

    @Override
    public void removeReadTransformer() {
        ReadTransformer transformer = this.buildReadTransformer();
        transformer.removeSelf();
    }

    @Override
    public void removeWriteTransformer(int index) {
        WriteTransfomer writeTransformer = this.buildWriteTransformer(index);
        writeTransformer.removeSelf();
    }

    @Override
    public void setFetchType(FetchType type) {
        this.setAttribute("fetch", (Enum<?>)type);
    }

    @Override
    public void setIsMutable(Boolean mutable) {
        this.setAttribute("mutable", mutable);
    }

    @Override
    public void setOptional(Boolean optional) {
        this.setAttribute("optional", optional);
    }

    @Override
    public List<ExternalWriteTransformer> writeTransformers() {
        int count = this.writeTransformersSize();
        ArrayList<ExternalWriteTransformer> transformers = new ArrayList<ExternalWriteTransformer>(count);
        int index = 0;
        while (index < count) {
            transformers.add(this.buildWriteTransformer(index));
            ++index;
        }
        return transformers;
    }

    @Override
    public int writeTransformersSize() {
        return this.getChildrenSize("write-transformer");
    }
}

