/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import org.eclipse.persistence.tools.mapping.orm.ExternalDiscriminatorClass;
import org.eclipse.persistence.tools.mapping.orm.ExternalDiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappingVisitor;
import org.eclipse.persistence.tools.mapping.orm.ExternalVariableOneToOneMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.DiscriminatorClass;
import org.eclipse.persistence.tools.mapping.orm.dom.DiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.Embeddable;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.NonTransientMapping;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

final class VariableOneToOneMapping
extends NonTransientMapping
implements ExternalVariableOneToOneMapping {
    private List<String> cascadeTypeIndices;

    VariableOneToOneMapping(Embeddable parent) {
        super(parent);
    }

    @Override
    public void accept(ExternalMappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void addCascadeType(CascadeType type) {
        Element element = this.getChild("cascade");
        if (element == null) {
            element = this.addChild("cascade");
        }
        this.addChild(element, this.cascadeType(type), this.cascadeTypeIndices);
    }

    @Override
    public ExternalDiscriminatorClass addDiscriminatorClass(String discrimator, String value) {
        DiscriminatorClass discriminatorClass = this.buildDiscriminatorClass(-1);
        discriminatorClass.addSelf();
        discriminatorClass.setDiscriminator(discrimator);
        discriminatorClass.setValue(value);
        return discriminatorClass;
    }

    @Override
    public ExternalDiscriminatorColumn addDiscriminatorColumn() {
        DiscriminatorColumn discriminatorColumn = this.buildDiscriminatorColumn();
        discriminatorColumn.addSelf();
        return discriminatorColumn;
    }

    @Override
    public ExternalJoinColumn addJoinColumn(String name) {
        JoinColumn joinColumn = this.buildJoinColumn(-1);
        joinColumn.addSelf();
        joinColumn.setName(name);
        return joinColumn;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("target-interface");
        names.add("fetch");
        names.add("optional");
        names.add("orphan-removal");
        return names;
    }

    private List<String> buildCascadeTypeIndices() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("cascade-all");
        names.add("cascade-persist");
        names.add("cascade-merge");
        names.add("cascade-remove");
        names.add("cascade-refresh");
        names.add("cascade-detach");
        return names;
    }

    private DiscriminatorClass buildDiscriminatorClass(int index) {
        return new DiscriminatorClass(this, index);
    }

    private DiscriminatorColumn buildDiscriminatorColumn() {
        return new DiscriminatorColumn(this);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("cascade");
        names.add("discriminator-column");
        names.add("discriminator-class");
        names.add("join-column");
        names.add("private-owned");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private JoinColumn buildJoinColumn(int index) {
        return new JoinColumn(this, "join-column", index);
    }

    private String cascadeType(CascadeType type) {
        switch (type) {
            case ALL: {
                return "cascade-all";
            }
            case DETACH: {
                return "cascade-detach";
            }
            case MERGE: {
                return "cascade-merge";
            }
            case PERSIST: {
                return "cascade-persist";
            }
            case REFRESH: {
                return "cascade-refresh";
            }
            case REMOVE: {
                return "cascade-remove";
            }
        }
        return null;
    }

    private CascadeType cascadeType(Element element) {
        String elementName = this.getNodeName(element);
        if (ObjectTools.equals((Object)elementName, (Object)"cascade-all")) {
            return CascadeType.ALL;
        }
        if (ObjectTools.equals((Object)elementName, (Object)"cascade-merge")) {
            return CascadeType.MERGE;
        }
        if (ObjectTools.equals((Object)elementName, (Object)"cascade-detach")) {
            return CascadeType.DETACH;
        }
        if (ObjectTools.equals((Object)elementName, (Object)"cascade-persist")) {
            return CascadeType.PERSIST;
        }
        if (ObjectTools.equals((Object)elementName, (Object)"cascade-refresh")) {
            return CascadeType.REFRESH;
        }
        if (ObjectTools.equals((Object)elementName, (Object)"cascade-remove")) {
            return CascadeType.REMOVE;
        }
        return null;
    }

    @Override
    public List<CascadeType> cascadeTypes() {
        Element element = this.getChild("cascade");
        if (element == null) {
            return Collections.emptyList();
        }
        List<Element> children = this.getChildren(element);
        ArrayList<CascadeType> cascadeTypes = new ArrayList<CascadeType>(children.size());
        for (Element childElement : children) {
            CascadeType cascadeType = this.cascadeType(childElement);
            if (cascadeType == null) continue;
            cascadeTypes.add(cascadeType);
        }
        return cascadeTypes;
    }

    @Override
    public List<ExternalDiscriminatorClass> discriminatorClasses() {
        int count = this.discriminatorClassesSize();
        ArrayList<ExternalDiscriminatorClass> discriminatorClasses = new ArrayList<ExternalDiscriminatorClass>(count);
        int index = 0;
        while (index < count) {
            discriminatorClasses.add(this.buildDiscriminatorClass(index));
            ++index;
        }
        return discriminatorClasses;
    }

    @Override
    public int discriminatorClassesSize() {
        return this.getChildrenSize("discriminator-class");
    }

    @Override
    public ExternalDiscriminatorClass getDiscriminatorClass(String value, String discriminator) {
        int count = this.discriminatorClassesSize();
        int index = 0;
        while (index < count) {
            DiscriminatorClass discriminatorClass = this.buildDiscriminatorClass(index);
            if (ObjectTools.equals((Object)discriminator, (Object)discriminatorClass.getDiscriminator()) && ObjectTools.equals((Object)value, (Object)discriminatorClass.getValue())) {
                return discriminatorClass;
            }
            ++index;
        }
        return null;
    }

    @Override
    public ExternalDiscriminatorColumn getDiscriminatorColumn() {
        if (this.hasChild("discriminator-column")) {
            return this.buildDiscriminatorColumn();
        }
        return null;
    }

    @Override
    protected String getElementName() {
        return "variable-one-to-one";
    }

    @Override
    public FetchType getFetchType() {
        return this.getEnumAttribute("fetch", FetchType.class);
    }

    @Override
    public TextRange getFetchTypeTextRange() {
        return this.getAttributeTextRange("fetch");
    }

    @Override
    public ExternalJoinColumn getJoinColumn(int index) {
        if (this.hasChild("join-column", index)) {
            return this.buildJoinColumn(index);
        }
        return null;
    }

    @Override
    public TextRange getOptionalTextRange() {
        return this.getAttributeTextRange("optional");
    }

    @Override
    public TextRange getOrphanRemovalTextRange() {
        return this.getAttributeTextRange("orphan-removal");
    }

    @Override
    public TextRange getPrivateOwnedTextRange() {
        return this.getChildTextRange("private-owned");
    }

    @Override
    public String getTargetInterfaceName() {
        return this.getAttribute("target-interface");
    }

    @Override
    public TextRange getTargetInterfaceNameTextRange() {
        return this.getAttributeTextRange("target-interface");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.cascadeTypeIndices = this.buildCascadeTypeIndices();
    }

    @Override
    public Boolean isOptional() {
        return this.getBooleanAttribute("optional");
    }

    @Override
    public Boolean isOrphanRemoval() {
        return this.getBooleanAttribute("orphan-removal");
    }

    @Override
    public Boolean isPrivateOwned() {
        return this.hasChild("private-owned");
    }

    @Override
    public List<ExternalJoinColumn> joinColumns() {
        int count = this.joinColumnsSize();
        ArrayList<ExternalJoinColumn> joinColumns = new ArrayList<ExternalJoinColumn>(count);
        int index = 0;
        while (index < count) {
            joinColumns.add(this.buildJoinColumn(index));
            ++index;
        }
        return joinColumns;
    }

    @Override
    public int joinColumnsSize() {
        return this.getChildrenSize("join-column");
    }

    @Override
    public void removeCascadeType(CascadeType type) {
        Element element = this.getChild("cascade");
        if (element != null) {
            this.removeChild(element, this.cascadeType(type));
            if (!this.hasAnyChildren(element)) {
                this.remove(element);
            }
        }
    }

    @Override
    public void removeDiscriminatorClass(int index) {
        DiscriminatorClass discClass = this.buildDiscriminatorClass(index);
        discClass.removeSelf();
    }

    @Override
    public void removeDiscriminatorColumn() {
        DiscriminatorColumn column = this.buildDiscriminatorColumn();
        column.removeSelf();
    }

    @Override
    public void removeJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.removeSelf();
    }

    @Override
    public void setFetchType(FetchType type) {
        this.setAttribute("fetch", (Enum<?>)type);
    }

    @Override
    public void setOptional(Boolean optional) {
        this.setAttribute("optional", optional);
    }

    @Override
    public void setOrphanRemoval(Boolean value) {
        this.setAttribute("orphan-removal", value);
    }

    @Override
    public void setPrivateOwned(Boolean privateOwned) {
        if (privateOwned == Boolean.TRUE) {
            this.addChild("private-owned");
        } else {
            this.removeChild("private-owned");
        }
    }

    @Override
    public void setTargetInterfaceName(String entityName) {
        this.setAttribute("target-interface", entityName);
    }
}

