/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.tests.dom.orm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.tools.mapping.ExternalProperty;
import org.eclipse.persistence.tools.mapping.ExternalPropertyHolder;
import org.eclipse.persistence.tools.mapping.tests.AbstractExternalFormTests.ChildListNodeTester;

/**
 * Defines the various testers for {@link ExternalPropertyHolder}.
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public final class PropertyTests {

	/**
	 * Cannot instantiate a new <code>PropertyTests</code>.
	 */
	private PropertyTests() {
		super();
	}

	public static <T extends ExternalPropertyHolder> ChildListNodeTester<T, ExternalProperty, String> buildPropertyTester() {
		return new ChildListNodeTester<T, ExternalProperty, String>() {
			@Override
			public ExternalProperty addChild(T form, String value) {
				return form.addProperty(value, null);
			}
			@Override
			public ExternalProperty getChild(T form, int index) {
				return form.getProperty(index);
			}
			@Override
			public ExternalProperty getChildForm(List<ExternalProperty> childForms, int index) {
				return childForms.get(index);
			}
			@Override
			public List<ExternalProperty> getChildren(T form) {
				return form.properties();
			}
			@Override
			public int getChildrenSize(T form) {
				return form.propertiesSize();
			}
			@Override
			public String getChildValue(ExternalProperty childForm) {
				return childForm.getName();
			}
			@Override
			public String getExpectedChildValue(int index) {
				return "PROPERTY_" + index;
			}
			@Override
			public List<String> getExpectedChildValues() {
				List<String> values = new ArrayList<String>();
				for (int index = 0; index < 10; index++) {
					values.add(getExpectedChildValue(index));
				}
				return values;
			}
			@Override
			public String getNodeName() {
				return ExternalProperty.PROPERTY;
			}
			@Override
			public List<String> getNodeNames() {
				return Collections.singletonList(getNodeName());
			}
			@Override
			public void removeChild(T form, int index) {
				form.removeProperty(index);
			}
		};
	}
}