/*******************************************************************************
 * Copyright (c) 2008, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.gen.db;

import org.eclipse.persistence.tools.utility.ObjectTools;

/**
 * An empty implementation of {@link ConnectionListener}.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.
 *
 * @version 2.6
 */
public class ConnectionAdapter implements ConnectionListener {

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void aboutToClose(ConnectionProfile profile) {
		// do nothing
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void catalogChanged(ConnectionProfile profile, Catalog catalog) {
		// do nothing
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void closed(ConnectionProfile profile) {
		// do nothing
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void columnChanged(ConnectionProfile profile, Column column) {
		// do nothing
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void databaseChanged(ConnectionProfile profile, Database database) {
		// do nothing
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void foreignKeyChanged(ConnectionProfile profile, ForeignKey foreignKey) {
		// do nothing
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void modified(ConnectionProfile profile) {
		// do nothing
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean okToClose(ConnectionProfile profile) {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void opened(ConnectionProfile profile) {
		// do nothing
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void schemaChanged(ConnectionProfile profile, Schema schema) {
		// do nothing
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void sequenceChanged(ConnectionProfile profile, Sequence sequence) {
		// do nothing
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void tableChanged(ConnectionProfile profile, Table table) {
		// do nothing
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return ObjectTools.toString(this);
	}
}