/*******************************************************************************
 * Copyright (c) 2010, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.iterable;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.iterator.SuperListIteratorWrapper;

/**
 * Wrap a list iterable of elements of any sub-type of <code>E</code>,
 * converting it into a <em>non-writable</em> list iterable of elements
 * of type <code>E</code>.
 * This shouldn't be a problem since the resulting list iterable's list
 * iterator disables the methods that would put invalid elements in the list
 * iterator's backing list (i.e. {@link SuperListIteratorWrapper#set(Object)}
 * and {@link SuperListIteratorWrapper#add(Object)}).
 *
 * @param <E> the type of elements returned by the iterable's iterators
 *
 * @see SuperListIteratorWrapper
 */
public class SuperListIterableWrapper<E>
	implements ListIterable<E>
{
	private final ListIterable<? extends E> iterable;


	public <T extends E> SuperListIterableWrapper(List<T> list) {
		this(new ListListIterable<T>(list));
	}

	public SuperListIterableWrapper(ListIterable<? extends E> iterable) {
		super();
		if (iterable == null) {
			throw new NullPointerException();
		}
		this.iterable = iterable;
	}

	@Override
	public ListIterator<E> iterator() {
		return new SuperListIteratorWrapper<E>(this.iterable.iterator());
	}

	@Override
	public String toString() {
		return this.iterable.toString();
	}
}