/*******************************************************************************
 * Copyright (c) 2007, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.model.value;

import java.io.Serializable;
import org.eclipse.persistence.tools.utility.model.AbstractModel;

/**
 * Implementation of {@link PropertyValueModel} that can be used for
 * returning a static value, but still allows listeners to be added.
 * Listeners will <em>never</em> be notified of any changes, because there should be none.
 */
public class StaticPropertyValueModel<T>
	extends AbstractModel
	implements PropertyValueModel<T>, Serializable
{
	/** The value. */
	protected final T value;

	private static final long serialVersionUID = 1L;


	/**
	 * Construct a static property value model for the specified value.
	 */
	public StaticPropertyValueModel(T value) {
		super();
		this.value = value;
	}


	// ********** PropertyValueModel implementation **********

	@Override
	public T getValue() {
		return this.value;
	}


	// ********** Object overrides **********

	@Override
	public void toString(StringBuilder sb) {
		sb.append(this.value);
	}
}