/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.model.value;

import org.eclipse.persistence.tools.utility.model.Model;
import org.eclipse.persistence.tools.utility.model.event.ChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.AbstractChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.ChangeListener;

/**
 * Extend {@link ValueAspectAdapter} to listen to all the aspects
 * of the value in the wrapped value model.
 */
public class ValueChangeAdapter<V extends Model>
	extends ValueAspectAdapter<V>
{
	/** Listener that listens to the value. */
	protected final ChangeListener valueAspectListener;


	// ********** constructors **********

	/**
	 * Construct a change adapter for the specified value.
	 */
	public ValueChangeAdapter(ModifiablePropertyValueModel<V> valueHolder) {
		super(valueHolder);
		this.valueAspectListener = this.buildValueAspectListener();
	}


	// ********** initialization **********

	protected ChangeListener buildValueAspectListener() {
		return new ValueAspectListener();
	}

	protected class ValueAspectListener
		extends AbstractChangeListener
	{
		@Override
		protected void modelChanged(ChangeEvent event) {
			ValueChangeAdapter.this.valueAspectChanged(event);
		}
	}


	// ********** ValueAspectAdapter implementation **********

	@Override
	protected void engageValue_() {
		this.value.addChangeListener(this.valueAspectListener);
	}

	@Override
	protected void disengageValue_() {
		this.value.removeChangeListener(this.valueAspectListener);
	}


	// ********** change events **********

	protected void valueAspectChanged(@SuppressWarnings("unused") ChangeEvent event) {
		this.valueAspectChanged();
	}
}