/*******************************************************************************
 * Copyright (c) 2010, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.command;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.command.Command;
import org.eclipse.persistence.tools.utility.command.CommandRunnable;

@SuppressWarnings("nls")
public class CommandRunnableTests extends TestCase {
	boolean commandExecuted = false;

	public CommandRunnableTests(String name) {
		super(name);
	}

	public void testNullCommand() {
		boolean exCaught = false;
		try {
			Runnable runnable = new CommandRunnable(null);
			fail("bogus: " + runnable);
		} catch (NullPointerException ex) {
			exCaught = true;
		}
		assertTrue(exCaught);
	}

	public void testRun() {
		Runnable runnable = new CommandRunnable(this.buildCommand());
		runnable.run();
		assertTrue(this.commandExecuted);
	}

	public void testToString() {
		Runnable runnable = new CommandRunnable(this.buildCommand());
		assertNotNull(runnable.toString());
	}

	private Command buildCommand() {
		return new Command() {
			@Override
			public void execute() {
				CommandRunnableTests.this.commandExecuted = true;
			}
		};
	}
}