/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.model;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.model.AbstractModel;
import org.eclipse.persistence.tools.utility.model.ChangeSupport;
import org.eclipse.persistence.tools.utility.model.Model;
import org.eclipse.persistence.tools.utility.model.SingleAspectChangeSupport;
import org.eclipse.persistence.tools.utility.model.listener.CollectionChangeAdapter;
import org.eclipse.persistence.tools.utility.model.listener.CollectionChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.ListChangeAdapter;
import org.eclipse.persistence.tools.utility.model.listener.ListChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.StateChangeListener;

@SuppressWarnings("nls")
public class SingleAspectChangeSupportTests extends TestCase {

	public SingleAspectChangeSupportTests(String name) {
		super(name);
	}

	public void testAddPropertyChangeListenerInvalidClass() {
		Model model = new StateTestModel();
		boolean exCaught = false;
		PropertyChangeListener listener = new PropertyChangeAdapter();
		try {
			model.addPropertyChangeListener("foo", listener);
			fail("bogus listener: " + listener);
		} catch (IllegalArgumentException ex) {
			exCaught = true;
		}
		assertTrue(exCaught);
	}

	public void testAddPropertyChangeListenerInvalidAspect() {
		Model model = new PropertyTestModel();
		boolean exCaught = false;
		PropertyChangeListener listener = new PropertyChangeAdapter();
		try {
			model.addPropertyChangeListener("bar", listener);
			fail("bogus listener: " + listener);
		} catch (IllegalArgumentException ex) {
			exCaught = true;
		}
		assertTrue(exCaught);
	}

	public void testAddCollectionChangeListenerInvalidClass() {
		Model model = new StateTestModel();
		boolean exCaught = false;
		CollectionChangeListener listener = new CollectionChangeAdapter();
		try {
			model.addCollectionChangeListener("foo", listener);
			fail("bogus listener: " + listener);
		} catch (IllegalArgumentException ex) {
			exCaught = true;
		}
		assertTrue(exCaught);
	}

	public void testAddCollectionChangeListenerInvalidAspect() {
		Model model = new CollectionTestModel();
		boolean exCaught = false;
		CollectionChangeListener listener = new CollectionChangeAdapter();
		try {
			model.addCollectionChangeListener("bar", listener);
			fail("bogus listener: " + listener);
		} catch (IllegalArgumentException ex) {
			exCaught = true;
		}
		assertTrue(exCaught);
	}

	public void testAddListChangeListenerInvalidClass() {
		Model model = new StateTestModel();
		boolean exCaught = false;
		ListChangeListener listener = new ListChangeAdapter();
		try {
			model.addListChangeListener("foo", listener);
			fail("bogus listener: " + listener);
		} catch (IllegalArgumentException ex) {
			exCaught = true;
		}
		assertTrue(exCaught);
	}

	public void testAddListChangeListenerInvalidAspect() {
		Model model = new ListTestModel();
		boolean exCaught = false;
		ListChangeListener listener = new ListChangeAdapter();
		try {
			model.addListChangeListener("bar", listener);
			fail("bogus listener: " + listener);
		} catch (IllegalArgumentException ex) {
			exCaught = true;
		}
		assertTrue(exCaught);
	}


	// ********** test models **********

	static class StateTestModel extends AbstractModel {
		StateTestModel() {
			super();
		}
		@Override
		protected ChangeSupport buildChangeSupport() {
			return new SingleAspectChangeSupport(this, StateChangeListener.class, null);
		}
	}

	static class PropertyTestModel extends AbstractModel {
		PropertyTestModel() {
			super();
		}
		@Override
		protected ChangeSupport buildChangeSupport() {
			return new SingleAspectChangeSupport(this, PropertyChangeListener.class, "foo");
		}
	}

	static class CollectionTestModel extends AbstractModel {
		CollectionTestModel() {
			super();
		}
		@Override
		protected ChangeSupport buildChangeSupport() {
			return new SingleAspectChangeSupport(this, CollectionChangeListener.class, "foo");
		}
	}

	static class ListTestModel extends AbstractModel {
		ListTestModel() {
			super();
		}
		@Override
		protected ChangeSupport buildChangeSupport() {
			return new SingleAspectChangeSupport(this, ListChangeListener.class, "foo");
		}
	}
}