/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface represents the basis for all basic collection mapping types defined by the
 * EclipseLink JPA spec that are available for configuration via the EclipseLink ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalBasicCollectionMapping extends ExternalConvertibleMapping {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String BASIC_COLLECTION = "basic-collection";

	/**
	 * The attribute name used to store and retrieve the fetch property.
	 */
	String FETCH = "fetch";

	/**
	 * The element name used to store and retrieve the join-fetch child text node.
	 */
	String JOIN_FETCH = "join-fetch";

	/**
	 * The element name used to store and retrieve the value-column child node.
	 */
	String VALUE_COLUMN = "value-column";

	/**
	 * Visits this {@link ExternalBasicCollectionMapping} by the given {@link ExternalMappingVisitor visitor}.
	 *
	 * @param visitor The {@link ExternalMappingVisitor} to visit this object
	 */
	void accept(ExternalMappingVisitor visitor);

	/**
	 * Adds a batch fetch to use.
	 */
	ExternalBatchFetch addBatchFetch();

	/**
	 * Adds a collection table to this mapping.
	 */
	ExternalCollectionTable addCollectionTable(String name);

	/**
	 * Adds the value column for this mapping.
	 */
	ExternalEntityColumn addValueColumn(String columnName);

	/**
	 * Returns the batch fetch definition for this mapping.
	 */
	ExternalBatchFetch getBatchFetch();

	/**
	 * Returns the collection table for this mapping.
	 */
	ExternalCollectionTable getCollectionTable();

	/**
	 * Returns the fetch type for this mapping.
	 */
	FetchType getFetchType();

	/**
	 * Returns the {@link TextRange} for the fetch type for this mapping.
	 */
	TextRange getFetchTypeTextRange();

	/**
	 * Returns the join fetch type for this mapping.
	 */
	JoinFetchType getJoinFetchType();

	/**
	 * Returns the {@link TextRange} for the join fetch type for this mapping.
	 */
	TextRange getJoinFetchTypeTextRange();

	/**
	 * Returns the value column for this mapping.
	 */
	ExternalEntityColumn getValueColumn();

	/**
	 * Removes the batch fetch.
	 */
	void removeBatchFetch();

	/**
	 * Removes the collection table from this mapping.
	 */
	void removeCollectionTable();

	/**
	 * Removes the value column from this mapping.
	 */
	void removeValueColumn();

	/**
	 * Sets the fetch type for this mapping.
	 */
	void setFetchType(FetchType type);

	/**
	 * Sets the join fetch type from this mapping.
	 */
	void setJoinFetchType(JoinFetchType type);
}