/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface describes the core definition of what a column is as pertains to the ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.Column
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html,
 * persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalBasicColumn extends ExternalForm {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String COLUMN = "column";

	/**
	 * The attribute name used to store and retrieve the column-definition property.
	 */
	String COLUMN_DEFINITION = "column-definition";

	/**
	 * The attribute name used to store and retrieve the insertable property.
	 */
	String INSERTABLE = "insertable";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	String NAME = "name";

	/**
	 * The attribute name used to store and retrieve the nullable property.
	 */
	String NULLABLE = "nullable";

	/**
	 * The attribute name used to store and retrieve the table property.
	 */
	String TABLE = "table";

	/**
	 * The attribute name used to store and retrieve the unique property.
	 */
	String UNIQUE = "unique";

	/**
	 * The attribute name used to store and retrieve the updatable property.
	 */
	String UPDATABLE = "updatable";

	/**
	 * Returns the native DDL or definition string representing this column.
	 */
	String getColumnDefinition();

	/**
	 * Returns the {@link TextRange} of the native DDL or definition string representing this column.
	 */
	TextRange getColumnDefinitionTextRange();

	/**
	 * Returns the text range of the name attribute.
	 */
	TextRange getColumnTextRange();

	/**
	 * Returns the {@link TextRange} of the insertable value.
	 */
	TextRange getInstertableTextRange();

	/**
	 * Returns the column name.
	 */
	String getName();

	/**
	 * Returns the {@link TextRange} of the column name.
	 */
	TextRange getNameTextRange();

	/**
	 * Returns the {@link TextRange} of the nullable value.
	 */
	TextRange getNullableTextRange();

	/**
	 * Returns name of the owning table for this column.
	 */
	String getTable();

	/**
	 * Returns the {@link TextRange} of the name of the owning table for this column.
	 */
	TextRange getTableTextRange();

	/**
	 * Returns the {@link TextRange} of the unique value.
	 */
	TextRange getUniqueTextRange();

	/**
	 * Returns the {@link TextRange} of the updatable value.
	 */
	TextRange getUpdatableTextRange();

	/**
	 * Indicates whether this column is insertable.
	 */
	Boolean isInstertable();

	/**
	 * Indicates whether this column is nullable.
	 */
	Boolean isNullable();

	/**
	 * Indicates whether this column is unique.
	 */
	Boolean isUnique();

	/**
	 * Indicates whether this column is updatable.
	 */
	Boolean isUpdatable();

	/**
	 * Sets the column definition
	 */
	void setColumnDefinition(String columnDefinition);

	/**
	 * Sets the boolean value of whether the column is insertable
	 */
	void setInsertable(Boolean insertable);

	/**
	 * Sets the name of the column
	 */
	void setName(String name);

	/**
	 * Sets the boolean value of whether the column is nullable
	 */
	void setNullable(Boolean nullable);

	/**
	 * Sets the table name
	 */
	void setTable(String table);

	/**
	 * Sets the boolean value of whether the column is unique.
	 */
	void setUnique(Boolean unique);

	/**
	 * Sets the boolean value of whether the column is updatable
	 */
	void setUpdatable(Boolean updatable);
}