/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describes the configurable properties for a database column
 * in the ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.Column
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalEntityColumn extends ExternalBasicColumn {

	/**
	 * The attribute name used to store and retrieve the length property.
	 */
	String LENGTH = "length";

	/**
	 * The attribute name used to store and retrieve the precision property.
	 */
	String PRECISION = "precision";

	/**
	 * The attribute name used to store and retrieve the scale property.
	 */
	String SCALE = "scale";

	/**
	 * Returns the column length.
	 */
	Integer getLength();

	/**
	 * Returns the {@link TextRange} for the length value.
	 */
	TextRange getLengthTextRange();

	/**
	 * Returns the column precision.
	 */
	Integer getPrecision();

	/**
	 * Returns the {@link TextRange} for the column precision value.
	 */
	TextRange getPrecisionTextRange();

	/**
	 * Returns the column scale.
	 */
	Integer getScale();

	/**
	 * Returns the {@link TextRange} for the column scale value.
	 */
	TextRange getScaleTextRange();

	/**
	 * Set the length of the database column.
	 */
	void setLength(Integer length);

	/**
	 * set the precision of the database column.
	 */
	void setPrecision(Integer precision);

	/**
	 * set the scale of the database column.
	 */
	void setScale(Integer scale);
}