/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and describes the configurable properties defined for an entity listener in the
 * ORM xml. Entity listeners may be declared at the root of the ORM, on entities, or individual
 * methods may be declared on an entity itself where the class name is presumed to be the entity.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.EntityListeners
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalEntityListener extends ExternalForm {

	/**
	 * The attribute name used to store and retrieve the class property.
	 */
	String CLASS = "class";

	/**
	 * The element name used to store and retrieve the description child node.
	 */
	String DESCRIPTION = "description";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String ENTITY_LISTENER = "entity-listener";

	/**
	 * The element name used to store and retrieve the entity-listeners parent node encapsulating the
	 * element represented by this external form.
	 */
	String ENTITY_LISTENERS = "entity-listeners";

	/**
	 * The attribute name used to store and retrieve the method-name property of the callback child nodes.
	 */
	String METHOD_NAME = "method-name";

	/**
	 * The element name used to store and retrieve the post-load child node.
	 */
	String POST_LOAD = "post-load";

	/**
	 * The element name used to store and retrieve the post-persist child node.
	 */
	String POST_PERSIST = "post-persist";

	/**
	 * The element name used to store and retrieve the post-remove child node.
	 */
	String POST_REMOVE = "post-remove";

	/**
	 * The element name used to store and retrieve the post-update child node.
	 */
	String POST_UPDATE = "post-update";

	/**
	 * The element name used to store and retrieve the pre-persist child node.
	 */
	String PRE_PERSIST = "pre-persist";

	/**
	 * The element name used to store and retrieve the pre-remove child node.
	 */
	String PRE_REMOVE = "pre-remove";

	/**
	 * The element name used to store and retrieve the pre-update child node.
	 */
	String PRE_UPDATE = "pre-update";

	/**
	 * Returns the class name of this listener or entity.
	 */
	String getClassName();

	/**
	 * Returns the {@link TextRange} of the class name.
	 */
	TextRange getClassNameTextRange();

	/**
	 * Returns the description.
	 */
	String getDescription();

	@Deprecated
	int getIndex();

	/**
	 * Returns the post-load method name.
	 */
	String getPostLoadMethod();

	/**
	 * Returns the post-load method description
	 */
	String getPostLoadMethodDescription();

	/**
	 * Returns the {@link TextRange} of the post-load method name.
	 */
	TextRange getPostLoadMethodTextRange();

	/**
	 * Returns the post-persist method name.
	 */
	String getPostPersistMethod();

	/**
	 * Returns the post-persist method description.
	 */
	String getPostPersistMethodDescription();

	/**
	 * Returns the {@link TextRange} of the post-persist method name.
	 */
	TextRange getPostPersistMethodTextRange();

	/**
	 * Returns the post-remove method name.
	 */
	String getPostRemoveMethod();

	/**
	 * Returns the post-remove method description.
	 */
	String getPostRemoveMethodDescription();

	/**
	 * Returns the {@link TextRange} of the post-remove method name.
	 */
	TextRange getPostRemoveMethodTextRange();

	/**
	 * Returns the post-update method name.
	 */
	String getPostUpdateMethod();

	/**
	 * Returns the post-update method description.
	 */
	String getPostUpdateMethodDescription();

	/**
	 * Returns the {@link TextRange} of the post-update method name.
	 */
	TextRange getPostUpdateMethodTextRange();

	/**
	 * Returns the pre-persist method name.
	 */
	String getPrePersistMethod();

	/**
	 * Returns the pre-persist method description.
	 */
	String getPrePersistMethodDescription();

	/**
	 * Returns the {@link TextRange} of the pre-persist method name.
	 */
	TextRange getPrePersistMethodTextRange();

	/**
	 * Returns the pre-remove method name.
	 */
	String getPreRemoveMethod();

	/**
	 * Returns the pre-remove method description.
	 */
	String getPreRemoveMethodDescription();

	/**
	 * Returns the {@link TextRange} of the pre-remove method name.
	 */
	TextRange getPreRemoveMethodTextRange();

	/**
	 * Returns the pre-update method name.
	 */
	String getPreUpdateMethod();

	/**
	 * Returns the pre-update method description.
	 */
	String getPreUpdateMethodDescription();

	/**
	 * Returns the {@link TextRange} of the pre-update method name.
	 */
	TextRange getPreUpdateMethodTextRange();

	/**
	 * Sets the class name of this listener.
	 */
	void setClassName(String name);

	/**
	 * Sets the description of this listener.
	 */
	void setDescription(String description);

	/**
	 * Sets the post-load method name.
	 */
	void setPostLoadMethod(String name);

	/**
	 * Sets the post-load method description.
	 */
	void setPostLoadMethodDescription(String name);

	/**
	 * Sets the post-persist method name.
	 */
	void setPostPersistMethod(String name);

	/**
	 * Sets the post-persist method description.
	 */
	void setPostPersistMethodDescription(String name);

	/**
	 * Sets the post-remove method name.
	 */
	void setPostRemoveMethod(String name);

	/**
	 * Sets the post-remove method description.
	 */
	void setPostRemoveMethodDescription(String name);

	/**
	 * Sets the post-update method name.
	 */
	void setPostUpdateMethod(String name);

	/**
	 * Sets the post-update method description.
	 */
	void setPostUpdateMethodDescription(String name);

	/**
	 * Sets the pre-persist method name.
	 */
	void setPrePersistMethod(String name);

	/**
	 * Sets the pre-persist method description.
	 */
	void setPrePersistMethodDescription(String name);

	/**
	 * Sets the pre-remove method name.
	 */
	void setPreRemoveMethod(String name);

	/**
	 * Sets the pre-remove method description.
	 */
	void setPreRemoveMethodDescription(String name);

	/**
	 * Sets the pre-update method name.
	 */
	void setPreUpdateMethod(String name);

	/**
	 * Sets the pre-update method description.
	 */
	void setPreUpdateMethodDescription(String name);
}