/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.mapping.ExternalForm;

/**
 * The external form representing the NoSQL database.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 * @since 2.5
 */
@SuppressWarnings("nls")
public interface ExternalNoSql extends ExternalForm {

	/**
	 * The attribute name used to store and retrieve the data format property.
	 */
	String DATA_FORMAT = "data-format";

	/**
	 * The attribute name used to store and retrieve the data type property.
	 */
	String DATA_TYPE = "data-type";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String NO_SQL = "no-sql";

	/**
	 * Returns the order of the fields contained in the database structure type.
	 */
	DataFormatType getDataFormat();

	/**
	 * Returns the database name of the database structure type.
	 */
	String getDataType();

	/**
	 * Sets the order of the fields contained in the database structure type.
	 */
	void setDataFormat(DataFormatType type);

	/**
	 * Sets the database name of the database structure type.
	 */
	void setDataType(String dataType);
}