/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface represents some common API for one-to-many, many-to-many, and element collection mappings.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalObjectCollectionMapping extends ExternalNonTransientMapping {

	/**
	 * The attribute name used to store and retrieve the class property.
	 */
	String CLASS = "class";

	/**
	 * The element name used to store and retrieve the map-key child node.
	 */
	String MAP_KEY = "map-key";

	/**
	 * The element name used to store and retrieve the map-key-association child nodes.
	 */
	String MAP_KEY_ASSOCIATION_OVERRIDE = "map-key-association-override";

	/**
	 * The element name used to store and retrieve the map-key-attribute child nodes.
	 */
	String MAP_KEY_ATTRIBUTE_OVERRIDE = "map-key-attribute-override";

	/**
	 * The element name used to store and retrieve the map-key-class child node.
	 */
	String MAP_KEY_CLASS = "map-key-class";

	/**
	 * The element name used to store and retrieve the map-key-column child node.
	 */
	String MAP_KEY_COLUMN = "map-key-column";

	/**
	 * The element name used to store and retrieve the map-key-convert child node.
	 */
	String MAP_KEY_CONVERT = "map-key-convert";

	/**
	 * The element name used to store and retrieve the map-key-enumerated child node.
	 */
	String MAP_KEY_ENUMERATED = "map-key-enumerated";

	/**
	 * The element name used to store and retrieve the map-key-join-column child node.
	 */
	String MAP_KEY_JOIN_COLUMN = "map-key-join-column";

	/**
	 * The element name used to store and retrieve the map-key-temporal child node.
	 */
	String MAP_KEY_TEMPORAL = "map-key-temporal";

	/**
	 * The element name used to store and retrieve the order-by child text node.
	 */
	String ORDER_BY = "order-by";

	/**
	 * Adds a override with the given name.
	 */
	ExternalAssociationOverride addMapKeyAssociationOverride();

	/**
	 * Adds a override with the given name.
	 */
	ExternalAttributeOverride addMapKeyAttributeOverride();

	/**
	 * Adds the map key column for this mapping.
	 */
	ExternalEntityColumn addMapKeyColumn();

	/**
	 * Adds a map key join column with the given name.
	 */
	ExternalJoinColumn addMapKeyJoinColumn(String name);

	/**
	 * Adds the order column for this mapping.
	 */
	ExternalOrderColumn addOrderColumn();

	/**
	 * Returns the map key.
	 */
	String getMapKey();

	/**
	 * Returns the association override at the specified index.
	 */
	ExternalAssociationOverride getMapKeyAssociationOverride(int index);

	/**
	 * Returns the attribute override at the specified index.
	 */
	ExternalAttributeOverride getMapKeyAttributeOverride(int index);

	/**
	 * Returns the map key class name.
	 */
	String getMapKeyClassName();

	/**
	 * Returns the {@link TextRange} for the map key class name.
	 */
	TextRange getMapKeyClassNameTextRange();

	/**
	 * Returns the map key column for this mapping.
	 */
	ExternalEntityColumn getMapKeyColumn();

	/**
	 * Returns the map key converter name for this mapping.
	 */
	String getMapKeyConverterName();

	/**
	 * Returns the {@link TextRange} for the map key converter name for this mapping.
	 */
	TextRange getMapKeyConverterNameTextRange();

	/**
	 * Returns the map key enumerated type for this mapping.
	 */
	EnumType getMapKeyEnumeratedType();

	/**
	 * Returns the {@link TextRange} for the map key enumerated type for this mapping.
	 */
	TextRange getMapKeyEnumeratedTypeTextRange();

	/**
	 * Returns a map key join column with the given name.
	 */
	ExternalJoinColumn getMapKeyJoinColumn(int index);

	/**
	 * Returns the temporal type for this mapping.
	 */
	TemporalType getMapKeyTemporalType();

	/**
	 * Returns the {@link TextRange} for the temporal type value.
	 */
	TextRange getMapKeyTemporalTypeTextRange();

	/**
	 * Returns the {@link TextRange} for the map key value.
	 */
	TextRange getMapKeyTextRange();

	/**
	 * Returns the order by string.
	 */
	String getOrderByFieldName();

	/**
	 * Returns the {@link TextRange> for the order by string value.
	 */
	TextRange getOrderByFieldNameTextRange();

	/**
	 * Returns the order column for this mapping.
	 */
	ExternalOrderColumn getOrderColumn();

	/**
	 * Determines whether the order-by child is present or not.
	 */
	boolean hasOrderByClause();

	/**
	 * Returns a list of association overrides defined on this mapping.
	 */
	List<ExternalAssociationOverride> mapKeyAssociationOverrides();

	/**
	 * Returns the count of association overrides defined on this entity.
	 */
	int mapKeyAssociationOverridesSize();

	/**
	 * Returns a list of overridden column mappings for embedded mapping.
	 */
	List<ExternalAttributeOverride> mapKeyAttributeOverrides();

	/**
	 * Returns the count of overridden column mappings for embedded fields.
	 */
	int mapKeyAttributeOverridesSize();

	/**
	 * Returns the map key join column for this mapping.
	 */
	List<ExternalJoinColumn> mapKeyJoinColumns();

	/**
	 * Returns the count of map key join columns for this mapping.
	 */
	int mapKeyJoinColumnsSize();

	/**
	 * Removes the override named
	 */
	void removeMapKeyAssociationOverride(int index);

	/**
	 * Removes the override named.
	 */
	void removeMapKeyAttributeOverride(int index);

	/**
	 * Removes the map key column from this mapping.
	 */
	void removeMapKeyColumn();

	/**
	 * Removes the map key join column named.
	 */
	void removeMapKeyJoinColumn(int index);

	/**
	 * Removes the order column from this mapping.
	 */
	void removeOrderColumn();

	/**
	 * Sets the map key.
	 */
	void setMapKey(String mapKey);

	/**
	 * Sets the map key class name.
	 */
	void setMapKeyClassName(String className);

	/**
	 * Sets the map key converter name.
	 */
	void setMapKeyConverterName(String converterName);

	/**
	 * Sets the enumerated type for this mapping.
	 */
	void setMapKeyEnumeratedType(EnumType enumType);

	/**
	 * Sets the temporal type.
	 */
	void setMapKeyTemporalType(TemporalType temporalType);

	/**
	 * Sets the order by string.
	 */
	void setOrderByFieldName(String orderBy);
}