/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;
import javax.persistence.CascadeType;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * Captures the common properties associated with all relationship mappings defined by the JPA
 * specification.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalRelationshipMapping extends ExternalMappedMapping {

	/**
	 * The element name used to store and retrieve the cascade child element.
	 */
	String CASCADE = "cascade";

	/**
	 * The element name used to store and retrieve the cascade-all child node of the cascade child.
	 */
	String CASCADE_ALL = "cascade-all";

	/**
	 * The element name used to store and retrieve the cascade-detach child node of the cascade child.
	 */
	String CASCADE_DETACH = "cascade-detach";

	/**
	 * The element name used to store and retrieve the cascade-merge child node of the cascade child.
	 */
	String CASCADE_MERGE = "cascade-merge";

	/**
	 * The element name used to store and retrieve the cascade-persist child node of the cascade child.
	 */
	String CASCADE_PERSIST = "cascade-persist";

	/**
	 * The element name used to store and retrieve the cascade-refresh child node of the cascade child.
	 */
	String CASCADE_REFRESH = "cascade-refresh";

	/**
	 * The element name used to store and retrieve the cascade-remove child node of the cascade child.
	 */
	String CASCADE_REMOVE = "cascade-remove";

	/**
	 * The attribute name used to store and retrieve the fetch property.
	 */
	String FETCH = "fetch";

	/**
	 * The element name used to store and retrieve the join-fetch child text node.
	 */
	String JOIN_FETCH = "join-fetch";

	/**
	 * The attribute name used to store and retrieve the optional property.
	 */
	String OPTIONAL = "optional";

	/**
	 * The attribute name used to store and retrieve the target-entity property.
	 */
	String TARGET_ENTITY = "target-entity";

	/**
	 * Adds a batch fetch to use.
	 */
	void addBatchFetch();

	/**
	 * Adds a cascaded type to use.
	 */
	void addCascadeType(CascadeType type);

	/**
	 * Creates new join table for this relationship mapping replacing the old one.
	 */
	ExternalJoinTable addJoinTable();

	/**
	 * Returns the enum, CascadeType to use for this relationship.
	 */
	List<CascadeType> cascadeTypes();

	/**
	 * Returns the batch fetch definition for this relationship mapping.
	 */
	ExternalBatchFetch getBatchFetch();

	/**
	 * Returns the {@link TextRange} of the cascade types.
	 */
	TextRange getCascadeTypeTextRange();

	/**
	 * Returns the join fetch type for this mapping.
	 */
	JoinFetchType getJoinFetchType();

	/**
	 * Returns the {@link TextRange} for the join fetch type value.
	 */
	TextRange getJoinFetchTypeTextRange();

	/**
	 * Returns the join table definition for this relationship mapping.
	 */
	ExternalJoinTable getJoinTable();

	/**
	 * Returns the relationship partner name for this mapping.
	 */
	String getTargetEntityName();

	/**
	 * Returns the {@link TextRange} for the relationship partner name for this mapping.
	 */
	TextRange getTargetEntityNameTextRange();

	/**
	 * Removes the batch fetch.
	 */
	void removeBatchFetch();

	/**
	 * Removes a cascade type.
	 */
	void removeCascadeType(CascadeType type);

	/**
	 * Removes the join table from this mapping.
	 */
	void removeJoinTable();

	/**
	 * Sets a join fetch type to this mapping.
	 */
	void setJoinFetchType(JoinFetchType type);

	/**
	 * Sets the relationship partner name.
	 */
	void setTargetEntityName(String entityName);
}