/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describe the configurable properties defined for a time of
 * day definition in the EclipseLink 1.1 ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.TimeOfDay
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalTimeOfDay extends ExternalForm {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String EXPIRY_TIME_OF_DAY = "expiry-time-of-day";

	/**
	 * The attribute name used to store and retrieve the hour property.
	 */
	String HOUR = "hour";

	/**
	 * The attribute name used to store and retrieve the millisecond property.
	 */
	String MILLISECOND = "millisecond";

	/**
	 * The attribute name used to store and retrieve the minute property.
	 */
	String MINUTE = "minute";

	/**
	 * The attribute name used to store and retrieve the second property.
	 */
	String SECOND = "second";

	/**
	 * Returns the hour value of the day.
	 */
	Integer getHour();

	/**
	 * Returns the {@link TextRange} for the hour value of the day.
	 */
	TextRange getHourTextRange();

	/**
	 * Returns the millisecond value of the day.
	 */
	Integer getMillisecond();

	/**
	 * Returns the {@link TextRange} for the millisecond value of the day.
	 */
	TextRange getMillisecondTextRange();

	/**
	 * Returns the minute value of the day.
	 */
	Integer getMinute();

	/**
	 * Returns the {@link TextRange} for the minute value of the day.
	 */
	TextRange getMinuteTextRange();

	/**
	 * Returns the second value of the day.
	 */
	Integer getSecond();

	/**
	 * Returns the {@link TextRange} for the second value of the day.
	 */
	TextRange getSecondTextRange();

	/**
	 * Sets the hour value for the day.
	 */
	void setHour(Integer hour);

	/**
	 * Sets the millisecond value for the day.
	 */
	void setMillisecond(Integer millisecond);

	/**
	 * Sets the minute value for the day.
	 */
	void setMinute(Integer minute);

	/**
	 * Sets the second value for the day.
	 */
	void setSecond(Integer second);
}