/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.DataFormatType;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSql;

/**
 * The external form of a NoSQL database.
 *
 * @version 2.6
 * @since 2.5
 */
final class NoSql extends AbstractExternalForm
                  implements ExternalNoSql {

	/**
	 * Creates a new <code>NoSql</code>.
	 *
	 * @param parent The parent of this external form
	 */
	NoSql(AbstractExternalForm parent) {
		super(parent);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public DataFormatType getDataFormat() {
		return getEnumAttribute(DATA_FORMAT, DataFormatType.class);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDataType() {
		return getAttribute(DATA_TYPE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return NO_SQL;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDataFormat(DataFormatType type) {
		setAttribute(DATA_FORMAT, type);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDataType(String dataType) {
		setAttribute(DATA_TYPE, dataType);
	}
}