/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalStructConverter;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * The external form of a struct converter.
 *
 * @see BasicMapMapping
 * @see ConvertibleMapping
 * @see ElementCollectionMapping
 * @see EmbeddableEntity
 * @see ORMConfiguration
 *
 * @version 2.6
 */
final class StructConverter extends AbstractConverter
                            implements ExternalStructConverter {

	/**
	 * Creates a new <code>StructConverter</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned by the parent
	 */
	StructConverter(AbstractExternalForm parent, int index) {
		super(parent, index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(NAME);
		names.add(CONVERTER);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getConverter() {
		return getAttribute(CONVERTER);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getConverterTextRange() {
		return getAttributeTextRange(CONVERTER);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return STRUCT_CONVERTER;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setConverter(String classname) {
		setAttribute(CONVERTER, classname);
	}
}