/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalTypeConverter;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * The external form of a type converter, which is a child of an entity.
 *
 * @see ConvertibleMapping
 * @see EmbeddableEntity
 * @see ORMConfiguration
 *
 * @version 2.6
 */
final class TypeConverter extends AbstractConverter
                          implements ExternalTypeConverter {

	/**
	 * Creates a new <code>TypeConverter</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned by the parent
	 */
	TypeConverter(AbstractExternalForm parent, int index) {
		super(parent, index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(NAME);
		names.add(DATA_TYPE);
		names.add(OBJECT_TYPE);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDatatype() {
		return getAttribute(DATA_TYPE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getDatatypeTextRange() {
		return getAttributeTextRange(DATA_TYPE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return TYPE_CONVERTER;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getObjecttype() {
		return getAttribute(OBJECT_TYPE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getObjecttypeTextRange() {
		return getAttributeTextRange(OBJECT_TYPE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDatatype(String datatypeName) {
		setAttribute(DATA_TYPE, datatypeName);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setObjecttype(String objecttypeName) {
		setAttribute(OBJECT_TYPE, objecttypeName);
	}
}