/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.persistence;

import java.net.URL;
import java.util.List;
import org.eclipse.persistence.tools.mapping.ExternalForm;

/**
 * The external representation of a Persistence Configuration file (persistence.xml).
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalPersistenceConfiguration extends ExternalForm {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String PERSISTENCE = "persistence";

	/**
	 * The element name of the child text node for version of the Persistence Configuration file.
	 */
	String VERSION = "version";

	/**
	 * Adds a persistence unit at the given index.
	 *
	 * @param name The name of the persistence unit to add
	 */
	ExternalPersistenceUnit addPersistenceUnit(String name);

	/**
	 * Returns the current build version of the product.
	 *
	 * @return The product's current version
	 */
	String getBuildVersion();

	/**
	 * Returns the document type of this Persistence Configuration.
	 *
	 * @return the document type.
	 */
	PersistenceDocumentType getDocumentType();

	/**
	 * Returns the location on the file system of the Persistence configuration file.
	 *
	 * @return The location on the file system of the Persistence configuration file
	 */
	URL getLocation();

	/**
	 * Retrieves the persistence unit with at the given position.
	 *
	 * @param index The position of the persistence unit to retrieve
	 * @return The external form of the persistence unit
	 */
	ExternalPersistenceUnit getPersistenceUnit(int index);

	/**
	 * Returns the persistence units owned by the Persistence Configuration
	 *
	 * @return The children of this external form
	 */
	List<ExternalPersistenceUnit> persistenceUnits();

	/**
	 * Returns the count of all the persistence units.
	 */
	int persistenceUnitsSize();

	/**
	 * Remove the persistence unit at the specified position.
	 *
	 * @param index The position of the persistence unit to remove
	 */
	void removePersistenceUnit(int index);

	/**
	 * Saves the content of this external form.
	 *
	 * @throws Exception If an error occurred while persisting the document
	 */
	void save() throws Exception;

	/**
	 * Sets the document type of the external Persistence Configuration.
	 *
	 * @param type the type of the document.
	 */
	void setDocumentType(PersistenceDocumentType type);
}