/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class EMCascadingModifyAndRefreshTest
extends EntityContainerTestBase {
    public Integer[] empIDs = new Integer[2];

    public EMCascadingModifyAndRefreshTest() {
        this.setDescription("Test cascading modify and refresh in EntityManager");
    }

    @Override
    public void setup() {
        super.setup();
        Employee employee = ModelExamples.employeeExample1();
        employee.addPhoneNumber(ModelExamples.phoneExample3());
        try {
            this.beginTransaction();
            this.getEntityManager().persist((Object)employee);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            ex.printStackTrace();
            throw new TestErrorException("Exception thrown durring persist and flush" + ex);
        }
        this.empIDs[0] = employee.getId();
    }

    public void test() {
        try {
            this.beginTransaction();
            Employee employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
            employee.setFirstName("Tobin");
            PhoneNumber phone = (PhoneNumber)employee.getPhoneNumbers().iterator().next();
            phone.setAreaCode("416");
            phone.setNumber("9876543");
            employee.addPhoneNumber(ModelExamples.phoneExample7());
            this.getEntityManager().refresh((Object)employee);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            ex.printStackTrace();
            throw new TestErrorException("Exception thrown durring persist and flush" + ex);
        }
    }

    public void verify() {
        Employee employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
        if (employee.getFirstName().equals("Tobin")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " first name updated after refresh");
        }
        if (employee.getPhoneNumbers().size() > 1) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " phone number added after refresh");
        }
        PhoneNumber phone = (PhoneNumber)employee.getPhoneNumbers().iterator().next();
        if (phone.getAreaCode().equals("416")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " phone number areacode modified after refresh");
        }
        if (phone.getNumber().equals("9876543")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " phone number modified after refresh");
        }
        ((JpaEntityManager)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
        if (employee.getFirstName().equals("Tobin")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " first name updated after refresh");
        }
        if (employee.getPhoneNumbers().size() > 1) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " phone number added after refresh");
        }
        phone = (PhoneNumber)employee.getPhoneNumbers().iterator().next();
        if (phone.getAreaCode().equals("416")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " phone number areacode modified after refresh");
        }
        if (phone.getNumber().equals("9876543")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " phone number modified after refresh");
        }
    }
}

