/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpql;

import java.sql.Date;
import java.util.Calendar;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.datetime.DateTimePopulator;
import org.eclipse.persistence.testing.models.jpa.datetime.DateTimeTableCreator;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitDomainObjectComparer;

public class JUnitJPQLModifyTestSuite
extends JUnitTestCase {
    static JUnitDomainObjectComparer comparer;

    public JUnitJPQLModifyTestSuite() {
    }

    public JUnitJPQLModifyTestSuite(String name) {
        super(name);
    }

    public void setUp() {
        ServerSession session = JUnitTestCase.getServerSession();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        EmployeePopulator employeePopulator = new EmployeePopulator();
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
        new DateTimeTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        DateTimePopulator dateTimePopulator = new DateTimePopulator();
        dateTimePopulator.persistExample((Session)JUnitJPQLModifyTestSuite.getServerSession());
    }

    public void tearDown() {
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("JUnitJPQLModifyTestSuite");
        suite.addTest((Test)new JUnitJPQLModifyTestSuite("testSetup"));
        suite.addTest((Test)new JUnitJPQLModifyTestSuite("simpleUpdate"));
        suite.addTest((Test)new JUnitJPQLModifyTestSuite("updateWithSubquery"));
        suite.addTest((Test)new JUnitJPQLModifyTestSuite("updateEmbedded"));
        suite.addTest((Test)new JUnitJPQLModifyTestSuite("updateEmbeddedFieldTest"));
        suite.addTest((Test)new JUnitJPQLModifyTestSuite("updateUnqualifiedAttributeInSet"));
        suite.addTest((Test)new JUnitJPQLModifyTestSuite("updateUnqualifiedAttributeInWhere"));
        suite.addTest((Test)new JUnitJPQLModifyTestSuite("updateUnqualifiedAttributeInWhereWithInputParameter"));
        suite.addTest((Test)new JUnitJPQLModifyTestSuite("updateDateTimeFields"));
        suite.addTest((Test)new JUnitJPQLModifyTestSuite("simpleDelete"));
        suite.addTest((Test)new JUnitJPQLModifyTestSuite("simpleUpdateWithInputParameters"));
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        ServerSession session = JUnitTestCase.getServerSession();
        comparer = new JUnitDomainObjectComparer();
        comparer.setSession((AbstractSession)session.getActiveSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleUpdate() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLModifyTestSuite.getServerSession().logMessage("Test simpleUpdate skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = this.createEntityManager();
        int nrOfEmps = this.executeJPQLReturningInt(em, "SELECT COUNT(e) FROM Employee e");
        String update = "UPDATE Employee e SET e.firstName = 'CHANGED'";
        this.beginTransaction(em);
        try {
            Query q = em.createQuery(update);
            int updated = q.executeUpdate();
            JUnitJPQLModifyTestSuite.assertEquals((String)"simpleUpdate: wrong number of updated instances", (int)nrOfEmps, (int)updated);
            this.commitTransaction(em);
            int nr = this.executeJPQLReturningInt(em, "SELECT COUNT(e) FROM Employee e WHERE e.firstName = 'CHANGED'");
            JUnitJPQLModifyTestSuite.assertEquals((String)"simpleUpdate: unexpected number of changed values in the database", (int)nrOfEmps, (int)nr);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWithSubquery() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLModifyTestSuite.getServerSession().logMessage("Test updateWithSubquery skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = this.createEntityManager();
        int nrOfEmps = this.executeJPQLReturningInt(em, "SELECT COUNT(e) FROM Employee e WHERE e.managedEmployees IS NOT EMPTY");
        String update = "UPDATE Employee e SET e.firstName = 'CHANGED' WHERE (SELECT COUNT(m) FROM e.managedEmployees m) > 0";
        this.beginTransaction(em);
        try {
            Query q = em.createQuery(update);
            int updated = q.executeUpdate();
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateWithSubquery: wrong number of updated instances", (int)nrOfEmps, (int)updated);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEmbedded() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLModifyTestSuite.getServerSession().logMessage("Test updateEmbedded skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = this.createEntityManager();
        int nrOfEmps = this.executeJPQLReturningInt(em, "SELECT COUNT(e) FROM Employee e");
        String update = "UPDATE Employee e SET e.period.startDate = NULL";
        this.beginTransaction(em);
        try {
            Query q = em.createQuery(update);
            int updated = q.executeUpdate();
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateEmbedded: wrong number of updated instances", (int)nrOfEmps, (int)updated);
            this.commitTransaction(em);
            int nr = this.executeJPQLReturningInt(em, "SELECT COUNT(e) FROM Employee e WHERE e.period.startDate IS NULL");
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateEmbedded: unexpected number of changed values in the database", (int)nrOfEmps, (int)nr);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEmbeddedFieldTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLModifyTestSuite.getServerSession().logMessage("Test updateEmbeddedFieldTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = this.createEntityManager();
        int nrOfEmps = this.executeJPQLReturningInt(em, "SELECT COUNT(e) FROM Employee e");
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.set(1905, 11, 31, 0, 0, 0);
        Date startDate = new Date(startCalendar.getTime().getTime());
        try {
            this.beginTransaction(em);
            em.createQuery("UPDATE Employee e SET e.period.startDate= :startDate").setParameter("startDate", (Object)startDate).executeUpdate();
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT COUNT(e) FROM Employee e WHERE e.period.startDate=:startDate").setParameter("startDate", (Object)startDate);
            Object result = q.getSingleResult();
            int nr = ((Number)result).intValue();
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateEmbedded: unexpected number of changed values in the database", (int)nrOfEmps, (int)nr);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUnqualifiedAttributeInSet() {
        int nr;
        int updated;
        Query q;
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLModifyTestSuite.getServerSession().logMessage("Test updateUnqualifiedAttributeInSet skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = this.createEntityManager();
        int nrOfEmps = this.executeJPQLReturningInt(em, "SELECT COUNT(e) FROM Employee e");
        String update = "UPDATE Employee SET firstName = 'CHANGED'";
        this.beginTransaction(em);
        try {
            q = em.createQuery(update);
            updated = q.executeUpdate();
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateUnqualifiedAttributeInSet: wrong number of updated instances", (int)nrOfEmps, (int)updated);
            this.commitTransaction(em);
            nr = this.executeJPQLReturningInt(em, "SELECT COUNT(e) FROM Employee e WHERE e.firstName = 'CHANGED'");
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateUnqualifiedAttributeInSet: unexpected number of changed values in the database", (int)nrOfEmps, (int)nr);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        update = "UPDATE Employee SET period.startDate = NULL";
        this.beginTransaction(em);
        try {
            q = em.createQuery(update);
            updated = q.executeUpdate();
            JUnitJPQLModifyTestSuite.assertEquals((String)"simpleUpdate: wrong number of updated instances", (int)nrOfEmps, (int)updated);
            this.commitTransaction(em);
            nr = this.executeJPQLReturningInt(em, "SELECT COUNT(e) FROM Employee e WHERE e.period.startDate IS NULL");
            JUnitJPQLModifyTestSuite.assertEquals((String)"simpleUpdate: unexpected number of changed values in the database", (int)nrOfEmps, (int)nr);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUnqualifiedAttributeInWhere() {
        int nr;
        int updated;
        Query q;
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLModifyTestSuite.getServerSession().logMessage("Test updateUnqualifiedAttributeInWhere skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = this.createEntityManager();
        int nrOfEmps = this.executeJPQLReturningInt(em, "SELECT COUNT(e) FROM Employee e WHERE e.firstName = 'Bob'");
        String update = "UPDATE Employee SET firstName = 'CHANGED' WHERE firstName = 'Bob'";
        this.beginTransaction(em);
        try {
            q = em.createQuery(update);
            updated = q.executeUpdate();
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateUnqualifiedAttributeInWhere: wrong number of updated instances", (int)nrOfEmps, (int)updated);
            this.commitTransaction(em);
            nr = this.executeJPQLReturningInt(em, "SELECT COUNT(e) FROM Employee e WHERE e.firstName = 'CHANGED'");
            JUnitJPQLModifyTestSuite.assertEquals((String)"simpleUnqualifiedUpdate: unexpected number of changed values in the database", (int)nrOfEmps, (int)nr);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        nrOfEmps = this.executeJPQLReturningInt(em, "SELECT COUNT(e) FROM Employee e WHERE e.managedEmployees IS NOT EMPTY");
        update = "UPDATE Employee SET firstName = 'MODIFIED' WHERE (SELECT COUNT(m) FROM managedEmployees m) > 0";
        this.beginTransaction(em);
        try {
            q = em.createQuery(update);
            updated = q.executeUpdate();
            JUnitJPQLModifyTestSuite.assertEquals((String)"simpleUpdate: wrong number of updated instances", (int)nrOfEmps, (int)updated);
            this.commitTransaction(em);
            nr = this.executeJPQLReturningInt(em, "SELECT COUNT(e) FROM Employee e WHERE e.firstName = 'MODIFIED'");
            JUnitJPQLModifyTestSuite.assertEquals((String)"simpleUpdate: unexpected number of changed values in the database", (int)nrOfEmps, (int)nr);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUnqualifiedAttributeInWhereWithInputParameter() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("update Employee set salary = :salary where version = :version");
            query.setParameter("salary", (Object)1);
            query.setParameter("version", (Object)2);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDateTimeFields() {
        EntityManager em = this.createEntityManager();
        int exp = this.executeJPQLReturningInt(em, "SELECT COUNT(d) FROM DateTime d");
        String jpql = null;
        int updated = 0;
        try {
            jpql = "UPDATE DateTime SET date = CURRENT_DATE";
            this.beginTransaction(em);
            updated = em.createQuery(jpql).executeUpdate();
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateDateTimeFields set date: wrong number of updated instances", (int)exp, (int)updated);
            this.commitTransaction(em);
            jpql = "SELECT COUNT(d) FROM DateTime d WHERE d.date <= CURRENT_DATE";
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateDateTimeFields set date: unexpected number of changed values in the database", (int)exp, (int)this.executeJPQLReturningInt(em, jpql));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        try {
            jpql = "UPDATE DateTime SET time = CURRENT_TIME";
            this.beginTransaction(em);
            updated = em.createQuery(jpql).executeUpdate();
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateDateTimeFields set time: wrong number of updated instances", (int)exp, (int)updated);
            this.commitTransaction(em);
            jpql = "SELECT COUNT(d) FROM DateTime d WHERE d.time <= CURRENT_TIME";
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateDateTimeFields set time: unexpected number of changed values in the database", (int)exp, (int)this.executeJPQLReturningInt(em, jpql));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        try {
            jpql = "UPDATE DateTime SET timestamp = CURRENT_TIMESTAMP";
            this.beginTransaction(em);
            updated = em.createQuery(jpql).executeUpdate();
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateDateTimeFields set timestamp: wrong number of updated instances", (int)exp, (int)updated);
            this.commitTransaction(em);
            jpql = "SELECT COUNT(d) FROM DateTime d WHERE d.timestamp <= CURRENT_TIMESTAMP";
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateDateTimeFields set timestamp: unexpected number of changed values in the database", (int)exp, (int)this.executeJPQLReturningInt(em, jpql));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        this.beginTransaction(em);
        try {
            jpql = "UPDATE DateTime SET utilDate = CURRENT_TIMESTAMP";
            updated = em.createQuery(jpql).executeUpdate();
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateDateTimeFields set utilDate: wrong number of updated instances", (int)exp, (int)updated);
            this.commitTransaction(em);
            jpql = "SELECT COUNT(d) FROM DateTime d WHERE d.utilDate <= CURRENT_TIMESTAMP";
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateDateTimeFields set utilDate: unexpected number of changed values in the database", (int)exp, (int)this.executeJPQLReturningInt(em, jpql));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        this.beginTransaction(em);
        try {
            jpql = "UPDATE DateTime SET calendar = CURRENT_TIMESTAMP";
            updated = em.createQuery(jpql).executeUpdate();
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateDateTimeFields set calendar: wrong number of updated instances", (int)exp, (int)updated);
            this.commitTransaction(em);
            jpql = "SELECT COUNT(d) FROM DateTime d WHERE d.calendar <= CURRENT_TIMESTAMP";
            JUnitJPQLModifyTestSuite.assertEquals((String)"updateDateTimeFields set calendar: unexpected number of changed values in the database", (int)exp, (int)this.executeJPQLReturningInt(em, jpql));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleDelete() {
        EntityManager em = this.createEntityManager();
        String jpql = "SELECT COUNT(p) FROM PhoneNumber p WHERE p.areaCode = '613'";
        int nrOfEmps = this.executeJPQLReturningInt(em, jpql);
        String delete = "DELETE FROM PhoneNumber p WHERE p.areaCode = '613'";
        this.beginTransaction(em);
        try {
            Query q = em.createQuery(delete);
            int deleted = q.executeUpdate();
            JUnitJPQLModifyTestSuite.assertEquals((String)"simpleDelete: wrong number of deleted instances", (int)nrOfEmps, (int)deleted);
            this.commitTransaction(em);
            int nr = this.executeJPQLReturningInt(em, jpql);
            JUnitJPQLModifyTestSuite.assertEquals((String)"simpleDelete: unexpected number of instances in the database", (int)0, (int)nr);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    private int executeJPQLReturningInt(EntityManager em, String jpql) {
        Query q = em.createQuery(jpql);
        Object result = q.getSingleResult();
        return ((Number)result).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleUpdateWithInputParameters() {
        if (this.getDatabaseSession().getPlatform().isSymfoware()) {
            JUnitJPQLModifyTestSuite.warning((String)"INTERSECT not supported on Symfoware.");
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            String jpql = "Update Employee a SET a.payScale = :acctStatus WHERE LOCATE(:acctName, a.lastName)> 0";
            Query query = em.createQuery(jpql);
            query.setParameter("acctStatus", (Object)Employee.SalaryRate.EXECUTIVE);
            query.setParameter("acctName", (Object)"Jones");
            int updated = query.executeUpdate();
            JUnitJPQLModifyTestSuite.assertEquals((String)"simpleUpdateWithInputParameters: did not update correclty", (int)2, (int)updated);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }
}

