/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.directmap;

import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.directmap.DirectMapMappings;
import org.eclipse.persistence.testing.models.directmap.IndirectMapSubclass;

public class DirectMapMappingsProject
extends Project {
    public DirectMapMappingsProject() {
        this.setName("DirectMapMappingsProject");
        this.applyLogin();
        this.addDescriptor((ClassDescriptor)this.buildDescriptors());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        login.usePlatform((DatabasePlatform)new OraclePlatform());
        login.setDriverClassName("oracle.jdbc.OracleDriver");
        login.setConnectionString("jdbc:oracle:thin:@localhost:1521:orcl");
        login.setUserName("scott");
        login.setEncryptedPassword("tiger");
        login.setUsesExternalConnectionPooling(false);
        login.setUsesExternalTransactionController(false);
        this.setLogin(login);
    }

    public RelationalDescriptor buildDescriptors() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(DirectMapMappings.class);
        descriptor.addTableName("DIRECTMAPMAPPINGS");
        descriptor.addPrimaryKeyFieldName("DIRECTMAPMAPPINGS.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("DIRECTMAPMAPPINGS.ID");
        descriptor.setSequenceNumberName("dmmappings_seq");
        descriptor.setAlias("DirectMapMappings");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("DIRECTMAPMAPPINGS.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectMapMapping directMapMapping = new DirectMapMapping();
        directMapMapping.setAttributeName("directMap");
        directMapMapping.setReferenceTableName("DIRECTMAP1");
        directMapMapping.setDirectFieldName("DIRECTMAP1.VAL");
        directMapMapping.setDirectKeyFieldName("DIRECTMAP1.KEY_FIELD");
        directMapMapping.addReferenceKeyFieldName("DIRECTMAP1.ID", "DIRECTMAPMAPPINGS.ID");
        directMapMapping.setReferenceClass(Hashtable.class);
        directMapMapping.setUsesIndirection(false);
        directMapMapping.useMapClass(Hashtable.class);
        directMapMapping.setKeyClass(Integer.class);
        directMapMapping.setValueClass(String.class);
        descriptor.addMapping((DatabaseMapping)directMapMapping);
        DirectMapMapping directMapBatchMapping = new DirectMapMapping();
        directMapBatchMapping.setAttributeName("directMapForBatchRead");
        directMapBatchMapping.setReferenceTableName("DIRECTMAP2");
        directMapBatchMapping.setDirectFieldName("DIRECTMAP2.VAL");
        directMapBatchMapping.setDirectKeyFieldName("DIRECTMAP2.KEY_FIELD");
        directMapBatchMapping.addReferenceKeyFieldName("DIRECTMAP2.ID", "DIRECTMAPMAPPINGS.ID");
        directMapBatchMapping.setReferenceClass(Hashtable.class);
        directMapBatchMapping.setUsesIndirection(false);
        directMapBatchMapping.useMapClass(Hashtable.class);
        directMapBatchMapping.setKeyClass(Integer.class);
        directMapBatchMapping.setValueClass(String.class);
        directMapBatchMapping.useBatchReading();
        descriptor.addMapping((DatabaseMapping)directMapBatchMapping);
        DirectMapMapping indirectionDirectMapMapping = new DirectMapMapping();
        indirectionDirectMapMapping.setAttributeName("indirectionDirectMap");
        indirectionDirectMapMapping.setReferenceTableName("DIRECTMAP3");
        indirectionDirectMapMapping.setDirectFieldName("DIRECTMAP3.VAL");
        indirectionDirectMapMapping.setDirectKeyFieldName("DIRECTMAP3.KEY_FIELD");
        indirectionDirectMapMapping.addReferenceKeyFieldName("DIRECTMAP3.ID", "DIRECTMAPMAPPINGS.ID");
        indirectionDirectMapMapping.setReferenceClass(Hashtable.class);
        indirectionDirectMapMapping.useTransparentMap();
        indirectionDirectMapMapping.useMapClass(IndirectMapSubclass.class);
        indirectionDirectMapMapping.setKeyClass(Integer.class);
        indirectionDirectMapMapping.setValueClass(String.class);
        descriptor.addMapping((DatabaseMapping)indirectionDirectMapMapping);
        DirectMapMapping directMapBlobMapping = new DirectMapMapping();
        directMapBlobMapping.setAttributeName("blobDirectMap");
        directMapBlobMapping.setReferenceTableName("DIRECTMAPBLOB");
        directMapBlobMapping.setDirectFieldName("DIRECTMAPBLOB.VAL");
        directMapBlobMapping.setDirectKeyFieldName("DIRECTMAPBLOB.KEY_FIELD");
        directMapBlobMapping.addReferenceKeyFieldName("DIRECTMAPBLOB.ID", "DIRECTMAPMAPPINGS.ID");
        directMapBlobMapping.setReferenceClass(Hashtable.class);
        directMapBlobMapping.setUsesIndirection(false);
        directMapBlobMapping.useMapClass(Hashtable.class);
        directMapBlobMapping.setKeyClass(Integer.class);
        directMapBlobMapping.setValueClass(Object.class);
        directMapBlobMapping.setValueConverter((Converter)new SerializedObjectConverter((DatabaseMapping)directMapBlobMapping));
        descriptor.addMapping((DatabaseMapping)directMapBlobMapping);
        DirectMapMapping directHashMapMapping = new DirectMapMapping();
        directHashMapMapping.setAttributeName("directHashMap");
        directHashMapMapping.setReferenceTableName("DIRECTMAP4");
        directHashMapMapping.setDirectFieldName("DIRECTMAP4.VAL");
        directHashMapMapping.setDirectKeyFieldName("DIRECTMAP4.KEY_FIELD");
        directHashMapMapping.addReferenceKeyFieldName("DIRECTMAP4.ID", "DIRECTMAPMAPPINGS.ID");
        directHashMapMapping.setReferenceClass(HashMap.class);
        directHashMapMapping.setUsesIndirection(false);
        directHashMapMapping.useMapClass(HashMap.class);
        directHashMapMapping.setKeyClass(Integer.class);
        directHashMapMapping.setValueClass(String.class);
        descriptor.addMapping((DatabaseMapping)directHashMapMapping);
        return descriptor;
    }
}

