/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.multipletable;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.multipletable.Budget;
import org.eclipse.persistence.testing.models.multipletable.BusinessProject;
import org.eclipse.persistence.testing.models.multipletable.LargeBusinessProject;

public class ProjectProject
extends Project {
    public ProjectProject() {
        this.applyPROJECT();
        this.applyLOGIN();
        this.buildBudgetDescriptor();
        this.buildBusinessProjectDescriptor();
        this.buildLargeBusinessProjectDescriptor();
    }

    protected void applyLOGIN() {
    }

    protected void applyPROJECT() {
        this.setName("SimpleMultipleTableSystem");
    }

    protected void buildBudgetDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Budget.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("BUDGET");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("BUDGET.ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberName("BUDG_SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("amount");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("BUDGET.AMNT");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("currency");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("BUDGET.CUR");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("id");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("BUDGET.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildBusinessProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(BusinessProject.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("PROJ");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("PROJ.PROJ_ID");
        descriptor.setSequenceNumberName("PROJ_SEQ");
        descriptor.useVersionLocking("VERSION");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberFieldName("PROJ_ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("PROJ_TYPE");
        descriptor.getInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getInheritancePolicy().addClassIndicator(LargeBusinessProject.class, (Object)"L");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("description");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("PROJ.DESCRIP");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("PROJ.PROJ_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("name");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("PROJ.PROJ_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildLargeBusinessProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(LargeBusinessProject.class);
        descriptor.getInheritancePolicy().setParentClass(BusinessProject.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("LPROJ");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("LPROJ.PROJ_ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(false);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("milestoneVersion");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("LPROJ.MILESTONE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("budget");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setReferenceClass(Budget.class);
        onetoonemapping.setIsPrivateOwned(true);
        onetoonemapping.addForeignKeyFieldName("LPROJ.BUDGET_ID", "BUDGET.ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }
}

