/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.unidirectional;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.UnidirectionalOneToManyMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.unidirectional.Employee;
import org.eclipse.persistence.testing.models.unidirectional.PhoneNumber;

public class EmployeeProject
extends Project {
    public static boolean ownerIdIsInPK = false;

    public EmployeeProject() {
        this.setName("UnidirectionalEmployee");
        this.addDescriptor(this.buildEmployeeDescriptor());
        this.addDescriptor(this.buildPhoneNumberDescriptor());
    }

    public ClassDescriptor buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Employee.class);
        descriptor.addTableName("UNIDIR_EMPLOYEE");
        descriptor.addPrimaryKeyFieldName("UNIDIR_EMPLOYEE.EMP_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("UNIDIR_EMPLOYEE.EMP_ID");
        descriptor.setSequenceNumberName("UNIDIR_EMP_SEQ");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("UNIDIR_EMPLOYEE.VERSION");
        lockingPolicy.setIsCascaded(true);
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.setAlias("UnidirectionalEmployee");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("firstName");
        firstNameMapping.setFieldName("UNIDIR_EMPLOYEE.F_NAME");
        firstNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)firstNameMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("UNIDIR_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping lastNameMapping = new DirectToFieldMapping();
        lastNameMapping.setAttributeName("lastName");
        lastNameMapping.setFieldName("UNIDIR_EMPLOYEE.L_NAME");
        lastNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)lastNameMapping);
        UnidirectionalOneToManyMapping managedEmployeesMapping = new UnidirectionalOneToManyMapping();
        managedEmployeesMapping.setAttributeName("managedEmployees");
        managedEmployeesMapping.setReferenceClass(Employee.class);
        managedEmployeesMapping.useBasicIndirection();
        managedEmployeesMapping.addTargetForeignKeyFieldName("UNIDIR_EMPLOYEE.MANAGER_ID", "UNIDIR_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)managedEmployeesMapping);
        UnidirectionalOneToManyMapping phoneNumbersMapping = new UnidirectionalOneToManyMapping();
        phoneNumbersMapping.setAttributeName("phoneNumbers");
        phoneNumbersMapping.setReferenceClass(PhoneNumber.class);
        phoneNumbersMapping.useBasicIndirection();
        phoneNumbersMapping.privateOwnedRelationship();
        phoneNumbersMapping.addTargetForeignKeyFieldName("UNIDIR_PHONE.EMP_ID", "UNIDIR_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)phoneNumbersMapping);
        return descriptor;
    }

    public ClassDescriptor buildPhoneNumberDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(PhoneNumber.class);
        descriptor.addTableName("UNIDIR_PHONE");
        if (ownerIdIsInPK) {
            descriptor.addPrimaryKeyFieldName("UNIDIR_PHONE.EMP_ID");
            descriptor.addPrimaryKeyFieldName("UNIDIR_PHONE.TYPE");
        } else {
            descriptor.addPrimaryKeyFieldName("UNIDIR_PHONE.AREA_CODE");
            descriptor.addPrimaryKeyFieldName("UNIDIR_PHONE.P_NUMBER");
        }
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setAlias("PhoneNumber");
        descriptor.getQueryManager().checkCacheForDoesExist();
        if (ownerIdIsInPK) {
            DirectToFieldMapping ownerIdMapping = new DirectToFieldMapping();
            ownerIdMapping.setAttributeName("ownerId");
            ownerIdMapping.setFieldName("UNIDIR_PHONE.EMP_ID");
            descriptor.addMapping((DatabaseMapping)ownerIdMapping);
        }
        DirectToFieldMapping areaCodeMapping = new DirectToFieldMapping();
        areaCodeMapping.setAttributeName("areaCode");
        areaCodeMapping.setFieldName("UNIDIR_PHONE.AREA_CODE");
        descriptor.addMapping((DatabaseMapping)areaCodeMapping);
        DirectToFieldMapping numberMapping = new DirectToFieldMapping();
        numberMapping.setAttributeName("number");
        numberMapping.setFieldName("UNIDIR_PHONE.P_NUMBER");
        descriptor.addMapping((DatabaseMapping)numberMapping);
        DirectToFieldMapping typeMapping = new DirectToFieldMapping();
        typeMapping.setAttributeName("type");
        typeMapping.setFieldName("UNIDIR_PHONE.TYPE");
        descriptor.addMapping((DatabaseMapping)typeMapping);
        return descriptor;
    }
}

