/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.customsqlstoredprocedures;

import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.StoredProcedureOutputListener;

public class StoredProcedureResultSetAndOutputTest
extends TestCase {
    protected StoredProcedureCall call = null;
    protected DatabaseException caughtException = null;
    protected Vector events = null;
    protected Vector result = null;
    private boolean shouldBindAllParameters;
    private boolean shouldBindAllParametersOriginal;

    public StoredProcedureResultSetAndOutputTest() {
        this(true);
    }

    public StoredProcedureResultSetAndOutputTest(boolean shouldBindAllParameters) {
        this.shouldBindAllParameters = shouldBindAllParameters;
        this.setName(this.getName() + " bind = " + shouldBindAllParameters);
    }

    public StoredProcedureCall getStoredProcedureCall() {
        return this.call;
    }

    public void setup() {
        this.shouldBindAllParametersOriginal = this.getSession().getLogin().shouldBindAllParameters();
        if (!this.getSession().getPlatform().isDB2() || this.getSession().getLogin().getDatabaseURL().indexOf("jcc") == -1) {
            throw new TestWarningException("This test can only be run in DB2, and not support jcc driver.");
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.events = new Vector();
        this.getSession().getEventManager().addListener((SessionEventListener)new StoredProcedureOutputListener(this.events));
        this.call = new StoredProcedureCall();
        this.getSession().getLogin().setShouldBindAllParameters(this.shouldBindAllParameters);
        this.buildStoredProcedureCall();
    }

    public void buildStoredProcedureCall() {
        this.call.setProcedureName("OUT_RES_TEST");
        this.call.addUnamedOutputArgument("OUT1");
        this.call.addUnamedOutputArgument("OUT2");
        this.call.addUnamedOutputArgument("OUT3");
        this.call.setReturnsResultSet(true);
    }

    public void test() {
        ReportQuery query = new ReportQuery(Employee.class, new ExpressionBuilder());
        query.setCall((Call)this.call);
        query.addAttribute("firstName");
        try {
            this.result = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        }
        catch (DatabaseException de) {
            this.caughtException = de;
        }
    }

    public void verify() throws Exception {
        if (this.caughtException != null) {
            throw new TestErrorException("Test to return a ResultSet and an OUT parameter from a stored procedure failed.\nThis exception thrown while testing test case.\n----- StoredProcedureResultSetAndOutputTest() -----\n" + this.caughtException.getMessage());
        }
        if (this.result == null || this.result.size() != 12) {
            throw new TestErrorException("The stored procedure was executed but no values were returned in the result set: " + this.result);
        }
        if (this.events.isEmpty() || ((DatabaseRecord)((SessionEvent)this.events.elementAt(0)).getResult()).getFields().size() != 3) {
            throw new TestErrorException("The stored procedure was executed but the return values were not returned.");
        }
    }

    public void reset() {
        this.getSession().getLogin().setShouldBindAllParameters(this.shouldBindAllParametersOriginal);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

