/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class InitializeDescriptorsBeforeLoginTest
extends AutoVerifyTestCase {
    DatabaseSession databaseSession;
    Exception exception;

    public InitializeDescriptorsBeforeLoginTest() {
        this.setDescription("Verifies that initializeDescriptors() may be called before login() and that sequencing settings may be altered in betwwen these two calls");
    }

    public void setup() {
        DatabaseLogin login = (DatabaseLogin)this.getSession().getLogin().clone();
        TableSequence ts = new TableSequence();
        Sequence seq = this.getSession().getDatasourcePlatform().getDefaultSequence();
        if (seq instanceof TableSequence) {
            ts.setTableName(((TableSequence)seq).getTableName());
        }
        login.setDefaultSequence((Sequence)ts);
        EmployeeProject project = new EmployeeProject();
        project.setLogin(login);
        this.databaseSession = project.createDatabaseSession();
        if (!this.databaseSession.getProject().usesSequencing()) {
            throw new TestWarningException("project doesn't use sequencing");
        }
        this.databaseSession.setSessionLog(this.getSession().getSessionLog());
    }

    public void test() {
        try {
            ((DatabaseSessionImpl)this.databaseSession).initializeDescriptors();
        }
        catch (Exception ex) {
            this.exception = ex;
        }
        this.databaseSession.getSequencingControl().setShouldUseSeparateConnection(true);
        this.databaseSession.login();
    }

    public void verify() {
        if (this.exception != null) {
            throw new TestErrorException("initializeDescriptors() failed");
        }
        if (!this.databaseSession.getSequencingControl().isConnectedUsingSeparateConnection()) {
            throw new TestErrorException("sequencing doesn't use separate connection");
        }
    }

    public void reset() {
        if (this.databaseSession != null) {
            if (this.databaseSession.isConnected()) {
                this.databaseSession.logout();
            }
            this.databaseSession = null;
        }
    }
}

