/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sequencing.UnaryTableSequence;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.sequencing.SeqTestClass2;

public class SequencingTableQualifierTest
extends AutoVerifyTestCase {
    public static final int TABLE_SEQUENCE = 1;
    public static final int UNARY_TABLE_SEQUENCE = 2;
    private int sequenceType = -1;
    private Sequence oldSequence;
    private String oldTableQualifier;
    private Exception storedException;

    public SequencingTableQualifierTest(int sequenceType) {
        this.sequenceType = sequenceType;
        this.setDescription("Test to check that setting a sequencing table qualifier works correctly");
    }

    public void setup() {
        this.oldSequence = this.getDatabaseSession().getLogin().getDefaultSequence();
        this.oldTableQualifier = this.getDatabaseSession().getLogin().getTableQualifier();
        this.getDatabaseSession().logout();
        Sequence newSequence = null;
        if (this.sequenceType == 1) {
            newSequence = this.createTableSequence();
        } else if (this.sequenceType == 2) {
            newSequence = this.createUnaryTableSequence();
        }
        this.getDatabaseSession().getLogin().setDefaultSequence(newSequence);
        this.getDatabaseSession().getLogin().setTableQualifier("INVALID_QUALIFIER");
        this.getDatabaseSession().login();
    }

    public Sequence createUnaryTableSequence() {
        return new UnaryTableSequence("ADDRESS_SEQ", 40, "COUNTER");
    }

    public Sequence createTableSequence() {
        String sequenceTableName = "SEQUENCE";
        if (this.getSession().getPlatform().getDefaultSequence().isTable()) {
            sequenceTableName = this.getSession().getPlatform().getQualifiedSequenceTableName();
        }
        return new TableSequence("", 50, sequenceTableName, "SEQ_NAME", "SEQ_COUNT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        UnitOfWork uow = this.getDatabaseSession().acquireUnitOfWork();
        try {
            SeqTestClass2 testObject = new SeqTestClass2();
            testObject.setTest1("Sequence Test Object");
            testObject.setTest2("test2");
            uow.registerObject((Object)testObject);
            uow.writeChanges();
        }
        catch (Exception e) {
            this.storedException = e;
        }
        finally {
            uow.release();
        }
    }

    public void verify() {
        if (this.storedException == null) {
            throw new TestErrorException("No exception thrown - sequencing table qualifier was not used");
        }
        if (this.getSession().getPlatform().isOracle() && this.storedException.getMessage().indexOf("ORA-00942") == -1) {
            throw new TestErrorException("Unexpected Oracle exception: " + this.storedException.getMessage());
        }
    }

    public void reset() {
        this.getDatabaseSession().logout();
        this.getDatabaseSession().getLogin().setDefaultSequence(this.oldSequence);
        this.getDatabaseSession().getLogin().setTableQualifier(this.oldTableQualifier);
        this.getDatabaseSession().login();
    }
}

