/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.TestCase;

public class SessionIsConnectedFlagTest
extends TestCase {
    public SessionIsConnectedFlagTest() {
        this.setDescription("Test Session isConnected flag pre-logout, post-logout and post-login");
    }

    public void test() {
        if (!this.getSession().isDatabaseSession()) {
            this.throwWarning("Test is designed to be run with DatabaseSession");
        }
        DatabaseSession session = (DatabaseSession)this.getSession();
        SessionIsConnectedFlagTest.assertTrue((String)"Session isConnected should be true before logout", (boolean)session.isConnected());
        for (Accessor accessor : ((DatabaseSessionImpl)session).getAccessors()) {
            SessionIsConnectedFlagTest.assertTrue((boolean)accessor.isConnected());
        }
        session.logout();
        SessionIsConnectedFlagTest.assertFalse((String)"Session isConnected should be false after logout", (boolean)session.isConnected());
        for (Accessor accessor : ((DatabaseSessionImpl)session).getAccessors()) {
            SessionIsConnectedFlagTest.assertFalse((boolean)accessor.isConnected());
        }
        session.login();
        SessionIsConnectedFlagTest.assertTrue((String)"Session isConnected should be true after login", (boolean)session.isConnected());
        for (Accessor accessor : ((DatabaseSessionImpl)session).getAccessors()) {
            SessionIsConnectedFlagTest.assertTrue((boolean)accessor.isConnected());
        }
    }
}

