/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.forceupdate;

import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.forceupdate.EmployeeTLIC;

public class FUVLNopTimestampLockInCacheTest
extends TransactionalTestCase {
    boolean exceptionCaught = false;
    int testnumber;

    public FUVLNopTimestampLockInCacheTest(int anInt) {
        this.testnumber = anInt;
        this.setName(this.getName() + "(Test" + anInt + ")");
        switch (this.testnumber) {
            case 1: {
                this.setDescription("Correctly use method forceUpdateToVersionField() with NOP");
                break;
            }
            case 2: {
                this.setDescription("forceUpdateToVersionField() with NOP doesn't effect read-only UOW");
                break;
            }
            case 3: {
                this.setDescription("Test method removeForceUpdateToVersionField()");
                break;
            }
            case 4: {
                this.setDescription("Demonstrate the result when no using forceUpdateToVersionField() with NOP");
                break;
            }
        }
    }

    public void test() {
        switch (this.testnumber) {
            case 1: {
                this.test1();
                break;
            }
            case 2: {
                this.test2();
                break;
            }
            case 3: {
                this.test3();
                break;
            }
            case 4: {
                this.test4();
                break;
            }
        }
    }

    public void test1() {
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp1 = bldr.get("firstName").equal((Object)"Bob");
        Expression exp2 = bldr.get("lastName").equal((Object)"Smith");
        Expression exp = exp1.and(exp2);
        EmployeeTLIC emp = (EmployeeTLIC)this.getSession().readObject(EmployeeTLIC.class, exp);
        UnitOfWork uow1 = this.getSession().acquireUnitOfWork();
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        EmployeeTLIC clone1 = (EmployeeTLIC)uow1.registerObject((Object)emp);
        EmployeeTLIC clone2 = (EmployeeTLIC)uow2.registerObject((Object)emp);
        uow1.forceUpdateToVersionField((Object)clone1.getAddress(), false);
        if (clone1.getAddress().getCountry() == "Canada") {
            clone1.setSalary(clone1.getSalary() + 200);
        }
        clone2.getAddress().setStreet("4 Hutton Centre,Suite 900");
        clone2.getAddress().setCity("Santa Ana");
        clone2.getAddress().setProvince("CA");
        clone2.getAddress().setCountry("USA");
        clone2.getAddress().setPostalCode("92797");
        uow2.commit();
        try {
            uow1.commit();
        }
        catch (OptimisticLockException exception) {
            this.exceptionCaught = true;
        }
    }

    public void test2() {
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp1 = bldr.get("firstName").equal((Object)"Bob");
        Expression exp2 = bldr.get("lastName").equal((Object)"Smith");
        Expression exp = exp1.and(exp2);
        EmployeeTLIC emp = (EmployeeTLIC)this.getSession().readObject(EmployeeTLIC.class, exp);
        UnitOfWork uow1 = this.getSession().acquireUnitOfWork();
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        EmployeeTLIC clone1 = (EmployeeTLIC)uow1.registerObject((Object)emp);
        EmployeeTLIC clone2 = (EmployeeTLIC)uow2.registerObject((Object)emp);
        uow1.forceUpdateToVersionField((Object)clone1.getAddress(), false);
        clone2.getAddress().setStreet("4 Hutton Centre,Suite 900");
        clone2.getAddress().setCity("Santa Ana");
        clone2.getAddress().setProvince("CA");
        clone2.getAddress().setCountry("USA");
        clone2.getAddress().setPostalCode("92797");
        uow2.commit();
        try {
            uow1.commit();
        }
        catch (OptimisticLockException exception) {
            this.exceptionCaught = true;
        }
    }

    public void test3() {
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp1 = bldr.get("firstName").equal((Object)"Bob");
        Expression exp2 = bldr.get("lastName").equal((Object)"Smith");
        Expression exp = exp1.and(exp2);
        EmployeeTLIC emp = (EmployeeTLIC)this.getSession().readObject(EmployeeTLIC.class, exp);
        UnitOfWork uow1 = this.getSession().acquireUnitOfWork();
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        EmployeeTLIC clone1 = (EmployeeTLIC)uow1.registerObject((Object)emp);
        EmployeeTLIC clone2 = (EmployeeTLIC)uow2.registerObject((Object)emp);
        uow1.forceUpdateToVersionField((Object)clone1.getAddress(), false);
        uow1.removeForceUpdateToVersionField((Object)clone1.getAddress());
        if (clone1.getAddress().getCountry() == "Canada") {
            clone1.setSalary(clone1.getSalary() + 200);
        }
        clone2.getAddress().setStreet("4 Hutton Centre,Suite 900");
        clone2.getAddress().setCity("Santa Ana");
        clone2.getAddress().setProvince("CA");
        clone2.getAddress().setCountry("USA");
        clone2.getAddress().setPostalCode("92797");
        uow2.commit();
        try {
            uow1.commit();
        }
        catch (OptimisticLockException exception) {
            this.exceptionCaught = true;
        }
    }

    public void test4() {
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp1 = bldr.get("firstName").equal((Object)"Bob");
        Expression exp2 = bldr.get("lastName").equal((Object)"Smith");
        Expression exp = exp1.and(exp2);
        EmployeeTLIC emp = (EmployeeTLIC)this.getSession().readObject(EmployeeTLIC.class, exp);
        UnitOfWork uow1 = this.getSession().acquireUnitOfWork();
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        EmployeeTLIC clone1 = (EmployeeTLIC)uow1.registerObject((Object)emp);
        EmployeeTLIC clone2 = (EmployeeTLIC)uow2.registerObject((Object)emp);
        if (clone1.getAddress().getCountry() == "Canada") {
            clone1.setSalary(clone1.getSalary() + 200);
        }
        clone2.getAddress().setStreet("4 Hutton Centre,Suite 900");
        clone2.getAddress().setCity("Santa Ana");
        clone2.getAddress().setProvince("CA");
        clone2.getAddress().setCountry("USA");
        clone2.getAddress().setPostalCode("92797");
        uow2.commit();
        try {
            uow1.commit();
        }
        catch (OptimisticLockException exception) {
            this.exceptionCaught = true;
        }
    }

    protected void verify() {
        switch (this.testnumber) {
            case 1: 
            case 2: {
                if (this.exceptionCaught) break;
                throw new TestErrorException("No Optimistic Lock exception was thrown");
            }
            case 3: 
            case 4: {
                if (!this.exceptionCaught) break;
                throw new TestErrorException("Optimistic Lock exception should not have been thrown");
            }
        }
    }
}

