/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.linkedlist.ExposedNodeLinkedList;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.SoftCacheWeakIdentityMap;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.identitymaps.ReadWeakIdentityMapTest;

public class ReadSoftCacheWeakIdentityMapTest
extends ReadWeakIdentityMapTest {
    public ReadSoftCacheWeakIdentityMapTest(Class mapClass) {
        super(mapClass);
        this.setDescription("This test verifies that the SoftCacheWeakIdentityMap holds onto the SoftReferences appropriately");
    }

    @Override
    public void test() {
        if (this.getIdentityMap().getSize() == 0) {
            throw new TestWarningException("We did not fill the cache, the test is invalid.");
        }
        ExposedNodeLinkedList list = ((SoftCacheWeakIdentityMap)this.getIdentityMap()).getReferenceCache();
        SoftReference ref = (SoftReference)list.getFirst();
        if (ref.get() == null) {
            throw new TestErrorException("Soft reference is null.");
        }
        ref = (SoftReference)list.getLast();
        if (ref.get() == null) {
            throw new TestErrorException("Soft reference is null.");
        }
        Vector<BigDecimal> vector = new Vector<BigDecimal>(10000);
        for (int i = 0; i < 10000; ++i) {
            vector.addElement(new BigDecimal(i));
        }
        System.gc();
        System.runFinalization();
        System.gc();
    }

    public void verify() {
        Map cache = this.getIdentityMap().getCacheKeys();
        int numObjects = 0;
        for (CacheKey key : cache.values()) {
            if (key.getObject() == null) continue;
            ++numObjects;
        }
        if (numObjects == this.querySize) {
            throw new TestWarningException("The SoftCacheWeakIdentityMap did not allow any garbage collection. This could be a VM thing");
        }
        if (numObjects < this.getIdentityMap().getMaxSize() / 2) {
            throw new TestWarningException("The SoftCacheWeakIdentityMap garbage collected the soft cache. This may be because of VM differences.");
        }
    }
}

