/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.interfaces;

import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.changesets.ObjectChangeSet;
import org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.interfaces.Asset;
import org.eclipse.persistence.testing.models.interfaces.Computer;
import org.eclipse.persistence.testing.models.interfaces.Email;
import org.eclipse.persistence.testing.models.interfaces.Employee;

public class PostCommitEventPrimaryKeyTest
extends AutoVerifyTestCase {
    private boolean emptyKey = false;
    private SessionEventAdapter eventAdapter = new SessionEventAdapter(){

        public void postCommitUnitOfWork(SessionEvent event) {
            PostCommitEventPrimaryKeyTest.this.commitOccurred(event);
        }
    };

    public PostCommitEventPrimaryKeyTest() {
        this.setDescription("Test that the primary key is correctly included with the Post Commit Event");
    }

    public void commitOccurred(SessionEvent event) {
        UnitOfWork uow = (UnitOfWork)event.getSession();
        UnitOfWorkChangeSet uowChangeSet = uow.getUnitOfWorkChangeSet();
        for (ObjectChangeSet objChangeSet : uowChangeSet.getAllChangeSets().keySet()) {
            Object objKey = objChangeSet.getId();
            if (objKey != null) continue;
            this.emptyKey = true;
        }
    }

    public void setup() {
        this.getSession().getEventManager().addListener((SessionEventListener)this.eventAdapter);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employee = (Employee)uow.registerObject((Object)new Employee());
        employee.asset1 = new Asset();
        employee.asset1.setAsset(Computer.example1());
        employee.asset2 = new Asset();
        employee.asset2.setAsset(Computer.example2());
        Email email = (Email)uow.registerObject((Object)new Email());
        employee.setContact(email);
        email.setHolder(employee);
        uow.commit();
    }

    public void verify() {
        if (this.emptyKey) {
            throw new TestErrorException("The change set for a Variable One-to-one mapping retured with a Null Primary Key.");
        }
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getSession().getEventManager().removeListener((SessionEventListener)this.eventAdapter);
    }
}

