/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;
import org.eclipse.persistence.testing.tests.jpql.NullDomainObjectComparer;

public class SelectSimpleNullTest
extends JPQLTestCase {
    private Expression originalObjectExpression;
    private Employee nullTestEmployee = null;

    public SelectSimpleNullTest(String theEjbqlString) {
        super(theEjbqlString);
    }

    public static SelectSimpleNullTest getSimpleNotNullTest() {
        SelectSimpleNullTest theTest = new SelectSimpleNullTest("SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName IS NOT NULL");
        theTest.setName("Select EJBQL Not Null Test");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").isNull().not();
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static SelectSimpleNullTest getSimpleNullTest() {
        SelectSimpleNullTest theTest = new SelectSimpleNullTest("SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName IS NULL");
        theTest.setName("Select EJBQL Null Test");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").isNull();
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    @Override
    public Expression getOriginalObjectExpression() {
        return this.originalObjectExpression;
    }

    @Override
    public void setOriginalObjectExpression(Expression theExpression) {
        this.originalObjectExpression = theExpression;
    }

    public Employee getNullTestEmployee() {
        if (this.nullTestEmployee == null) {
            this.nullTestEmployee = new Employee();
            this.nullTestEmployee.setFemale();
            this.nullTestEmployee.setFirstName(null);
            this.nullTestEmployee.setLastName("NullTestEmployee");
            this.nullTestEmployee.setSalary(35000);
        }
        return this.nullTestEmployee;
    }

    @Override
    public void setup() {
        NullDomainObjectComparer comparer = new NullDomainObjectComparer();
        comparer.setSession(this.getSession());
        this.setComparer(comparer);
        this.getDatabaseSession().writeObject((Object)this.getNullTestEmployee());
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(this.getOriginalObjectExpression());
        this.setOriginalOject(this.getSession().executeQuery((DatabaseQuery)raq));
        super.setup();
    }

    @Override
    public void reset() {
        this.getDatabaseSession().deleteObject((Object)this.getNullTestEmployee());
        super.reset();
    }
}

