/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.querycache;

import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.NoExpiryCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.queries.QueryResultsCachePolicy;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.querycache.NamedQueryQueryCacheTest;

public class QueryCacheInvalidationTest
extends NamedQueryQueryCacheTest {
    protected int invalidationPolicyType = 0;
    protected boolean expiringTest = false;
    protected int sleepTime = 0;
    public static final int NO_INVALIDATION = 0;
    public static final int TIME_TO_LIVE_INVALIDATION = 1;
    public static final int DAILY_INVALIDATION = 2;

    public QueryCacheInvalidationTest(int invalidationPolicyType, boolean expiringTest) {
        this.setName("QueryCacheInvalidationTest invalidationType: " + invalidationPolicyType + " expiring: " + expiringTest);
        this.setDescription("Test the various cache invalidation polcies on the query cache.");
        this.invalidationPolicyType = invalidationPolicyType;
        this.expiringTest = expiringTest;
    }

    protected CacheInvalidationPolicy getInvalidationPolicy() {
        NoExpiryCacheInvalidationPolicy invalidationPolicy = null;
        if (this.invalidationPolicyType == 0) {
            invalidationPolicy = new NoExpiryCacheInvalidationPolicy();
        } else if (this.invalidationPolicyType == 1) {
            if (this.expiringTest) {
                invalidationPolicy = new TimeToLiveCacheInvalidationPolicy(0L);
                this.expectedSQLCount = 1;
                this.sleepTime = 100;
            } else {
                invalidationPolicy = new TimeToLiveCacheInvalidationPolicy(1000000L);
            }
        } else if (this.expiringTest) {
            this.expectedSQLCount = 1;
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(new Date(System.currentTimeMillis() + 1000L));
            invalidationPolicy = new DailyCacheInvalidationPolicy(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
            this.sleepTime = 1500;
        } else {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(new Date(System.currentTimeMillis() + 1000000L));
            invalidationPolicy = new DailyCacheInvalidationPolicy(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
        }
        return invalidationPolicy;
    }

    @Override
    public ReadQuery getQueryForTest() {
        ReadQuery testQuery = super.getQueryForTest();
        testQuery.setQueryResultsCachePolicy(new QueryResultsCachePolicy(this.getInvalidationPolicy()));
        return testQuery;
    }

    @Override
    public void test() {
        try {
            Thread.sleep(this.sleepTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.test();
    }
}

